% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moransi.R
\name{PermutationMoransI}
\alias{PermutationMoransI}
\title{Permutation based Moran's I}
\usage{
PermutationMoransI(
  x,
  W,
  n = 999,
  seed = 1,
  normalize = TRUE,
  return.permutation = FALSE
)
}
\arguments{
\item{x}{A numerical vector.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{n}{The number of permutations to be conducted, set to 999 by default.}

\item{seed}{Random seed used. Default is 1.}

\item{normalize}{Whether to normalize the weight matrix such that each row adds up to one. Default is \code{TRUE}.}

\item{return.permutation}{Return permutations. Default is \code{FALSE}.}
}
\value{
A list containing the following:
\itemize{
\item Morans.I, the Moran's I.
\item p.val, permutation based p-value.
\item return.permutation, permutation used if returned.
}
}
\description{
Calculate permutation based p-value for Moran's I.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- PermutationMoransI(data.use[,3], W)
}

}
\concept{moransi}
