% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{PermutationLocalI}
\alias{PermutationLocalI}
\title{Permutation based local Moran's I}
\usage{
PermutationLocalI(
  x,
  W,
  n = 999,
  seed = 1,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH",
  normalize = TRUE,
  scale = TRUE,
  return.permutation = FALSE,
  condition = 0
)
}
\arguments{
\item{x}{A numerical vector.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{n}{The number of permutations to be conducted, set to 999 by default.}

\item{seed}{Random seed used. Default is 1.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}

\item{normalize}{Whether to normalize the weight matrix such that each row adds up to one. Default is \code{TRUE}.}

\item{scale}{Whether to scale the data. Default is \code{TRUE}.}

\item{return.permutation}{Return permutations. Default is \code{FALSE}.}

\item{condition}{Value under null hypothesis to compare with, default is 0.}
}
\value{
A list containing the following:
\itemize{
\item Local.Morans.I, local Moran's I.
\item p.val, permutation based p-value.
\item p.adj, adjusted p-values.
\item scale.factor, number of observations.
\item return.permutation, permutation used if returned.
\item params, parameters used to calculate local Moran's I.
}
}
\description{
Calculate permutation based p-value for local Moran's I.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- PermutationLocalI(data.use[,3], W)
}

}
\concept{local}
