% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moransi.R
\name{IrregularData}
\alias{IrregularData}
\title{Process irregular data shape (between two groups) for Moran's I}
\usage{
IrregularData(X, W, group1, group2)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{group1}{The indices or names for the first group of observations.}

\item{group2}{The indices or names for the second group of observations.}
}
\value{
A list containing the following:
\itemize{
\item X, new data matrix of group1 and group2.
\item W, new weight matrix of group1 and group2.
}
}
\description{
Process irregular data shape for Moran's I between two groups.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- IrregularData(data.use[,3:4], W, 1:10, 21:30)
}

}
\concept{moransi}
