% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-lacrosse.R
\name{lacrosse_goal_fan}
\alias{lacrosse_goal_fan}
\title{The goal arc fan is present on some fields (e.g. NCAAW) as a quarter-circle
located around the goal. The anchor for this feature should be given as the
center of the goal line, but the radius of the arc actually corresponds to
a point on the goal circle (see \code{\link[=lacrosse_goal_circle]{lacrosse_goal_circle()}}) that runs through
\code{y = 0}}
\usage{
lacrosse_goal_fan(
  goal_fan_radius = 0,
  goal_circle_radius = 0,
  line_thickness = 0
)
}
\arguments{
\item{goal_fan_radius}{The outer radius of the goal fan, measured from the
center of the goal line to the outer edge of the goal fan}

\item{goal_circle_radius}{The radius of the goal circle}

\item{line_thickness}{The thickness of the goal fan line}
}
\value{
A data frame containing the bounding coordinates of the goal fan
}
\description{
The goal arc fan is present on some fields (e.g. NCAAW) as a quarter-circle
located around the goal. The anchor for this feature should be given as the
center of the goal line, but the radius of the arc actually corresponds to
a point on the goal circle (see \code{\link[=lacrosse_goal_circle]{lacrosse_goal_circle()}}) that runs through
\code{y = 0}
}
\keyword{internal}
