% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-volleyball.R
\name{volleyball_free_zone}
\alias{volleyball_free_zone}
\title{The free zone is similar to the \code{\link[=basketball_court_apron]{basketball_court_apron()}} in that it is the
area outside the court. It may be the same color as the interior of the
court, but isn't necessarily. Unlike \code{\link[=basketball_court_apron]{basketball_court_apron()}} however, the
boundary line thickness doesn't matter since the lines are considered in-play
and therefore are included in the court's length and width. This is not the
same as the \code{\link[=volleyball_court_apron]{volleyball_court_apron()}}, as this is the entire area outside of
the court's lines, while the court apron corresponds to a colored apron
inside the free zone}
\usage{
volleyball_free_zone(
  court_length = 0,
  court_width = 0,
  free_zone_end_line = 0,
  free_zone_sideline = 0
)
}
\arguments{
\item{court_length}{The length of the court, measured from the exterior edges
of the end lines}

\item{court_width}{The width of the court, measured from the exterior edges
of the sidelines}

\item{free_zone_end_line}{The distance the free zone extends beyond
the outer edge of the end line}

\item{free_zone_sideline}{The distance the free zone extends beyond
the outer edge of the sideline}
}
\value{
A data frame containing the bounding coordinates of the free zone
}
\description{
The free zone is similar to the \code{\link[=basketball_court_apron]{basketball_court_apron()}} in that it is the
area outside the court. It may be the same color as the interior of the
court, but isn't necessarily. Unlike \code{\link[=basketball_court_apron]{basketball_court_apron()}} however, the
boundary line thickness doesn't matter since the lines are considered in-play
and therefore are included in the court's length and width. This is not the
same as the \code{\link[=volleyball_court_apron]{volleyball_court_apron()}}, as this is the entire area outside of
the court's lines, while the court apron corresponds to a colored apron
inside the free zone
}
\keyword{internal}
