% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esv.R
\name{esv}
\alias{esv}
\alias{plot.esv}
\title{Compute the empirical semivariogram}
\usage{
esv(
  formula,
  data,
  xcoord,
  ycoord,
  cloud = FALSE,
  bins = 15,
  cutoff,
  dist_matrix,
  partition_factor
)

\method{plot}{esv}(x, ...)
}
\arguments{
\item{formula}{A formula describing the fixed effect structure.}

\item{data}{A data frame or \code{sf} object containing the variables in \code{formula}
and geographic information.}

\item{xcoord}{Name of the variable in \code{data} representing the x-coordinate.
Can be quoted or unquoted. Not required if \code{data} is an \code{sf} object.}

\item{ycoord}{Name of the variable in \code{data} representing the y-coordinate.
Can be quoted or unquoted. Not required if \code{data} is an \code{sf} object.}

\item{cloud}{A logical indicating whether the empirical semivariogram should
be summarized by distance class or not. When \code{cloud = FALSE} (the default), pairwise semivariances
are binned and averaged within distance classes. When \code{cloud} = TRUE,
all pairwise semivariances and distances are returned (this is known as
the "cloud" semivariogram).}

\item{bins}{The number of equally spaced bins. The default is 15. Ignored if
\code{cloud = TRUE}.}

\item{cutoff}{The maximum distance considered.
The default is half the diagonal of the bounding box from the coordinates.}

\item{dist_matrix}{A distance matrix to be used instead of providing coordinate names.}

\item{partition_factor}{An optional formula specifying the partition factor.
If specified, semivariances are only computed for observations sharing the
same level of the partition factor.}

\item{x}{An object from \code{esv()}.}

\item{...}{Other arguments passed to other methods.}
}
\value{
If \code{cloud = FALSE}, a tibble (data.frame) with distance bins
(\code{bins}), the average distance (\code{dist}), the average semivariance (\code{gamma}), and the
number of (unique) pairs (\code{np}). If \code{cloud = TRUE}, a tibble
(data.frame) with distance (\code{dist}) and semivariance (\code{gamma})
for each unique pair.
}
\description{
Compute the empirical semivariogram for varying bin sizes and
cutoff values.
}
\details{
The empirical semivariogram is a tool used to visualize and model
spatial dependence by estimating the semivariance of a process at varying distances.
For a constant-mean process, the
semivariance at distance \eqn{h} is denoted \eqn{\gamma(h)} and defined as
\eqn{0.5 * Var(z1  - z2)}. Under second-order stationarity,
\eqn{\gamma(h) = Cov(0) - Cov(h)}, where \eqn{Cov(h)} is the covariance function at distance \code{h}. Typically the residuals from an ordinary
least squares fit defined by \code{formula} are second-order stationary with
mean zero. These residuals are used to compute the empirical semivariogram.
At a distance \code{h}, the empirical semivariance is
\eqn{1/N(h) \sum (r1 - r2)^2}, where \eqn{N(h)} is the number of (unique)
pairs in the set of observations whose distance separation is \code{h} and
\code{r1} and \code{r2} are residuals corresponding to observations whose
distance separation is \code{h}. In spmodel, these distance bins actually
contain observations whose distance separation is \code{h +- c},
where \code{c} is a constant determined implicitly by \code{bins}. Typically,
only observations whose distance separation is below some cutoff are used
to compute the empirical semivariogram (this cutoff is determined by \code{cutoff}).

When using \code{\link[=splm]{splm()}} with \code{estmethod} as \code{"sv-wls"}, the empirical
semivariogram is calculated internally and used to estimate spatial
covariance parameters.
}
\examples{
esv(sulfate ~ 1, sulfate)
plot(esv(sulfate ~ 1, sulfate))
}
