% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooks.distance.R
\name{cooks.distance.spmodel}
\alias{cooks.distance.spmodel}
\alias{cooks.distance.splm}
\alias{cooks.distance.spautor}
\title{Compute Cook's distance}
\usage{
\method{cooks.distance}{splm}(model, ...)

\method{cooks.distance}{spautor}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A vector of Cook's distance values for each observation from the
fitted model object.
}
\description{
Compute the Cook's distance for each observation from a fitted
model object.
}
\details{
Cook's distance measures the influence of an observation on a fitted
model object. If an observation is influential, its omission from the data
noticeably impacts parameter estimates. The larger the Cook's distance, the
larger the influence.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
cooks.distance(spmod)
}
\seealso{
\code{\link[=hatvalues.spmodel]{hatvalues.spmodel()}} \code{\link[=influence.spmodel]{influence.spmodel()}} \code{\link[=residuals.spmodel]{residuals.spmodel()}}
}
