% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_normalize_write.R
\name{spm12_normalize_write}
\alias{spm12_normalize_write}
\alias{build_spm12_normalize_write}
\title{SPM12 Normalize (Write)}
\usage{
spm12_normalize_write(
  deformation,
  other.files = NULL,
  bounding_box = matrix(c(-90, -126, -72, 90, 90, 108), nrow = 2, byrow = TRUE),
  voxel_size = c(2, 2, 2),
  interp = c("bspline4", "nearestneighbor", "trilinear", paste0("bspline", 2:3),
    paste0("bspline", 5:7)),
  retimg = FALSE,
  reorient = FALSE,
  add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE,
  verbose = TRUE,
  install_dir = NULL,
  ...
)

build_spm12_normalize_write(
  deformation,
  other.files = NULL,
  bounding_box = matrix(c(-90, -126, -72, 90, 90, 108), nrow = 2, byrow = TRUE),
  voxel_size = c(2, 2, 2),
  interp = c("bspline4", "nearestneighbor", "trilinear", paste0("bspline", 2:3),
    paste0("bspline", 5:7)),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{deformation}{Filename of deformation (nifti)}

\item{other.files}{Files to be written using the estimated
normalization}

\item{bounding_box}{matrix (2x3) of the bounding box to use.
Default is for MNI 2mm template
size}

\item{voxel_size}{The voxel sizes (x, y & z, in mm) 
of the written normalised images.}

\item{interp}{Interpolator for sampling in fixed space}

\item{retimg}{Logical indicating if image should be returned or
result from \code{\link{run_matlab_script}}}

\item{reorient}{if \code{retimg=TRUE} pass to 
\code{\link{readNIfTI}}}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
List of SPM object, results, and output filenames
}
\description{
Applies SPM12 (Spatial) Normalization to images
}
\examples{
dims = rep(10, 3)
temp_nii = array(rnorm(prod(dims)), dim = dims)
temp_nii = oro.nifti::nifti(temp_nii)
res = build_spm12_normalize_write(temp_nii, 
other.files = temp_nii,
install_dir = tempdir())
}
