% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_smooth.R
\name{spm12_smooth}
\alias{spm12_smooth}
\title{SPM12 Smooth}
\usage{
spm12_smooth(filename, retimg = FALSE, fwhm = 8, dtype = c("SAME",
  "UINT8", "INT16", "INT32", "FLOAT32", "FLOAT64"),
  implicit_mask = FALSE, prefix = "s", add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE, verbose = TRUE, reorient = FALSE,
  install_dir = NULL, ...)
}
\arguments{
\item{filename}{File to be smoothed}

\item{retimg}{Logical indicating if image should be returned or
result from \code{\link{run_matlab_script}}}

\item{fwhm}{Full-Width Half Max to smooth}

\item{dtype}{data type for the output format}

\item{implicit_mask}{Should an implicit mask be used.
An "implicit mask" is a mask implied by a 
particular voxel value (0 for images with integer type, 
\code{NaN} for float images).}

\item{prefix}{Prefix to append to front of image filename}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{reorient}{if \code{retimg=TRUE} pass to \code{\link{readNIfTI}}}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}
\code{\link{readNIfTI}}}
}
\value{
Result from run_matlab_script or nifti file, depending on
\code{retimg}
}
\description{
Performs SPM12 Smoothing on an Image
}
