% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_segment.R
\name{spm12_segment}
\alias{spm12_segment}
\title{SPM12 Segment}
\usage{
spm12_segment(filename, set_origin = TRUE, biasreg = 0.001,
  biasfwhm = 60, native = TRUE, dartel = FALSE, modulated = FALSE,
  unmodulated = FALSE, bias_field = FALSE, bias_corrected = FALSE,
  n_gaus = c(1, 1, 2, 3, 4, 2), smoothness = 0,
  sampling_distance = 3, regularization = c(0, 0.001, 0.5, 0.05, 0.2),
  affine = c("mni", "eastern", "subj", "none"), mrf = 1,
  def_inverse = TRUE, def_forward = TRUE, warp_cleanup = c("light",
  "none", "thorough"), retimg = TRUE, add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE, verbose = TRUE, reorient = FALSE,
  install_dir = NULL, ...)
}
\arguments{
\item{filename}{File to be segmented}

\item{set_origin}{Run \code{\link{acpc_reorient}} on image first.
Warning, this will set the orientation differently}

\item{biasreg}{Amount of bias regularization}

\item{biasfwhm}{FWHM  of  Gaussian  smoothness  of  bias.}

\item{native}{Keep tissue class image (c*) in alignment with the original.}

\item{dartel}{Keep tissue class image (rc*) that can be used with the 
Dartel toolbox .}

\item{modulated}{Keep modulated images.  Modulation  is  to  compensate
for  the  effect of spatial normalisation.}

\item{unmodulated}{Keep unmodulated data}

\item{bias_field}{save a bias corrected version of your images}

\item{bias_corrected}{save an estimated bias field from  your images}

\item{n_gaus}{The number of Gaussians used to represent the 
intensity distribution for each tissue class.  Can be 1:8 or infinity}

\item{smoothness}{FWHM of smoothing done}

\item{sampling_distance}{smoothingess of the warping field. 
This is used to derive a fudge factor to account for 
correlations between neighbouring voxels.  Smoother data have more}

\item{regularization}{parameters for warping regularization}

\item{affine}{Space to register the image to, using an affine registration}

\item{mrf}{strength of the Markov random field. 
Setting the value to zero will disable the cleanup.}

\item{def_inverse}{keep the inverse deformation field}

\item{def_forward}{keep the forward deformation field}

\item{warp_cleanup}{Level of cleanup with the warping.
If you find pieces of brain being chopped out in your data, 
then you may wish to disable or tone down the cleanup procedure.}

\item{retimg}{Logical indicating if image should be returned or
result from \code{\link{run_matlab_script}}}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{reorient}{if \code{retimg=TRUE} pass to \code{\link{readNIfTI}}}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
List of output files (or niftis depending on \code{retimg}),
output matrix, and output deformations.
}
\description{
Performs SPM12 Segmentation on an Image
}
