\name{timeSequence-class}
\alias{timeSequence-class}
\alias{[,timeSequence-method}
\alias{[<-,timeSequence,ANY,ANY,ANY-method}
\alias{[[,timeSequence-method}
\alias{[[<-,timeSequence-method}
\alias{as.character,timeSequence-method}
\alias{c,timeSequence-method}
\alias{coerce,timeSequence,integer-method}
\alias{coerce,timeSequence,numeric-method}
\alias{coerce,timeSequence,character-method}
\alias{coerce,timeSequence,timeDate-method}
\alias{coerce,timeDate,timeSequence-method}
\alias{duplicated,timeSequence-method}
\alias{is.na,timeSequence-method}
\alias{is.nan,timeSequence-method}
\alias{length,timeSequence-method}
\alias{length<-,timeSequence-method}
\alias{shiftPositions,timeSequence-method}
\alias{show,timeSequence-method}
\alias{summary,timeSequence-method}
\alias{which.na,timeSequence-method}
%
\title{
  Time Sequence Class 
}
\docType{class}
\description{
This class is a compact representation of a  
time/date vector in an arithemetic sequence. 
}
\section{Slots}{
  \describe{
    \item{from}{
      (\code{timeDate}) the start of the sequence. 
    }
    \item{to}{
      (\code{timeDate}) the end of the sequence. 
    }
    \item{by}{
      (\code{timeInterval}) the increment for the sequence. 
    }
    \item{length}{
      (\code{integer}) the length of the sequence. 
    }
    \item{exceptions}{
      (\code{event}) time periods to remove from the sequence.
    }
    \item{additions}{
      (\code{positionsCalendar}) times/dates to add to the sequence. 
    }
    \item{format}{
      (\code{character}) the time/date output format for sequence display. 
    }
    \item{time.zone}{
      (\code{character}) the time zone for the sequence. 
    }
  }
}
\details{
The \code{timeSequence} class extends the \code{positionsCalendar} class. 

Valid \code{timeSequence} objects must contain a single non-\code{NA} value in 
at least three of the \code{from}, \code{to}, \code{by}, and \code{length} slots.   
If all four are present, the \code{length} 
slot is ignored, and a warning message is generated when  
the sequence is used.  If \code{length} is present and not being ignored, it must 
be non-negative (that is, a zero-length sequence is equivalent to \code{timeDate()}). 
Otherwise, to have a valid sequence, adding \code{by} to \code{from} must go 
towards \code{to}.  The default sequence (generated by calling \code{timeSequence()} or  
\code{new("timeSequence")}) has length 0. 

A \code{timeSequence} can be coerced to \code{timeDate} using \code{as}, 
and regularly-spaced times/dates (or time/date vectors spaced 
by regular numbers of months) can be coerced to \code{timeSequence}  
using \code{as}. This fails if the input is not a regular 
sequence within a tolerance given by \code{timeDateOptions("ts.eps")}.  

Most operations that work for \code{timeDate} objects also work on \code{timeSequence}  
objects (for example, mathematical functions, arithmetic, 
comparison operators, and subscripting) by first coercing to a time/date  
vector. Therefore they do not return \code{timeSequence} objects.  Because 
of this, it is more efficient to coerce a \code{timeSequence} 
to \code{timeDate} using \code{as} before performing an extended set of 
calculations on the original object, rather than coercing  
for each operation. 
}
\seealso{
\code{\link{timeSequence}}  function.  
}
\keyword{classes}
% docclass is function
% Converted by mySd2Rd version 47442.
