% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_print.R
\name{terminalNodeSummary}
\alias{terminalNodeSummary}
\title{Prints a summary of a terminal node in a tree}
\usage{
terminalNodeSummary(tree, node = NULL)
}
\arguments{
\item{tree}{A splinetree object}

\item{node}{The number of the node that you want summarized. To see which nodes correspond to
which numbers, see stPrint(tree) or treeSummary(tree). If this parameter is provided, must correspond
to a valid terminal node in the tree.}
}
\description{
If no argument is provided for the parameter \code{node}, summaries are printed for every
terminal node. Otherwise, the summary of just the requested node is printed.
}
\examples{
\donttest{
split_formula <- ~HISP + WHITE + BLACK + SEX + Num_sibs + HGC_FATHER + HGC_MOTHER
tree <- splineTree(split_formula, BMI~AGE, idvar = "ID",
   data = nlsySample, degree = 1, df = 3,
   intercept = TRUE, cp = 0.005)
}
terminalNodeSummary(tree)
}
