% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_WMRR.R
\name{scaleWMRR}
\alias{scaleWMRR}
\title{Scaling by wavelet multiresolution regression (WMRR)}
\usage{
scaleWMRR(formula, family, data, coord, scale = 1, detail = TRUE,
  wavelet = "haar", wtrafo = "dwt", b.ini = NULL, pad = list(),
  control = list(), moran.params = list(), trace = FALSE)
}
\arguments{
\item{formula}{With specified notation according to names in data frame.}

\item{family}{\code{gaussian}, \code{binomial}, or \code{poisson}.}

\item{data}{Data frame.}

\item{coord}{Corresponding coordinates which have to be integer.}

\item{scale}{0 (which is equivalent to GLM) or
higher integers possible (limit depends on sample size).}

\item{detail}{Remove smooth wavelets? If \code{TRUE}, only detail components are analyzed.
If set to \code{FALSE}, smooth and detail components are analyzed. Default is \code{TRUE}.}

\item{wavelet}{Type of wavelet: \code{haar} or \code{d4} or \code{la8}}

\item{wtrafo}{Type of wavelet transform: \code{dwt} or \code{modwt}.}

\item{b.ini}{Initial parameter values. Default is \code{NULL}.}

\item{pad}{A list of parameters for padding wavelet coefficients.
\itemize{
   \item{padform} - 0, 1, and 2 are possible.
    \code{padform} is automatically set to
    0 when either \code{level}=0 or
    the \code{formula} includes an intercept and has a non-\code{gaussian}
     \code{family}.
   \itemize{
     \item{0} - Padding with 0s.
     \item{1} - Padding with mean values.
     \item{2} - Padding with mirror values.
 }
   \item{padzone} - Factor for expanding the padding zone
}}

\item{control}{A list of parameters for controlling the fitting process.
   \itemize{
      \item{\code{eps}} - Positive convergence tolerance. Smaller values of
      \code{eps} provide better parameter estimates, but also reduce the probability
      of the iterations converging. In case of issues with convergence, test larger
      values of \code{eps}. Default is 10^-5.
      \item{\code{denom.eps}} - Default is 10^-20.
      \item{\code{itmax}} - Integer giving the maximum number of iterations.
      Default is 200.
}}

\item{moran.params}{A list of parameters for calculating Moran's I.
\itemize{
  \item\code{lim1} - Lower limit for first bin. Default is 0.
  \item\code{increment} - Step size for calculating Moran's I. Default is 1.
}}

\item{trace}{A logical value indicating whether to print parameter estimates
to the console}
}
\value{
scaleWMRR returns a list containing the following elements
\describe{
  \item{\code{call}}{Model call}
  \item{\code{b}}{Estimates of regression parameters}
  \item{\code{s.e.}}{Standard errors of the parameter estimates}
  \item{\code{z}}{Z values (or corresponding values for statistics)}
  \item{\code{p}}{p-values for each parameter estimate}
  \item{\code{df}}{Degrees of freedom}
  \item{\code{fitted}}{Fitted values}
  \item{\code{resid}}{Pearson residuals}
  \item{\code{converged}}{Logical value whether the procedure converged}
  \item{\code{trace}}{Logical. If TRUE:}

    \itemize{
      \item\code{ac.glm} Autocorrelation of glm.residuals

      \item\code{ac} Autocorrelation of wavelet.residuals
  }

}
}
\description{
scaleWMRR performs a scale-specific regression based on a
wavelet multiresolution analysis.
}
\details{
This function fits generalized linear models while taking the
two-dimensional grid structure of
datasets into account. The following error distributions (in
conjunction with appropriate link functions) are allowed: \code{gaussian},
\code{binomial}, or \code{poisson}. The model provides scale-specific
results for data sampled on a contiguous geographical area. The
dataset is assumed to be regular gridded and the grid cells are
assumed to be square. A function from the package 'waveslim' is used
for the wavelet transformations (Whitcher, 2005).
Furthermore, this function requires that \strong{all predictor variables
be continuous}.
}
\examples{

data(carlinadata)
coords <- carlinadata[ ,4:5]

\dontrun{

# scaleWMRR at scale = 0 is equivalent to GLM

ms0 <- scaleWMRR(carlina.horrida ~ aridity + land.use,
                 family = "poisson",
                 data = carlinadata,
                 coord = coords,
                 scale = 0,
                 trace = TRUE)

# scale-specific regressions for detail components
ms1 <- scaleWMRR(carlina.horrida ~ aridity + land.use,
                 family = "poisson",
                 data = carlinadata,
                 coord = coords,
                 scale = 1,
                 trace = TRUE)

ms2 <- scaleWMRR(carlina.horrida ~ aridity + land.use,
                 family = "poisson",
                 data = carlinadata,
                 coord = coords,
                 scale = 2,
                 trace = TRUE)

ms3<- scaleWMRR(carlina.horrida ~ aridity + land.use,
                 family = "poisson",
                 data = carlinadata,
                 coord = coords,
                 scale = 3,
                 trace = TRUE)

}
}
\references{
Carl G, Doktor D, Schweiger O, Kuehn I (2016)
Assessing relative variable importance across different spatial
scales: a two-dimensional wavelet analysis.
Journal of Biogeography 43: 2502-2512.

Whitcher, B. (2005) Waveslim: basic wavelet routines for one-, two-
and three-dimensional signal processing. R package version 1.5.
}
\seealso{
\pkg{waveslim},\code{\link[waveslim]{mra.2d}}
}
\author{
Gudrun Carl
}
