% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmiGEE.R
\name{mmiGEE}
\alias{mmiGEE}
\title{Multi-model inference for GEE models}
\usage{
mmiGEE(object, data, trace = FALSE)
}
\arguments{
\item{object}{A model of class \code{GEE}.}

\item{data}{A data frame or set of vectors of equal length.}

\item{trace}{A logical indicating whether or not to print results to console.}
}
\value{
\code{mmiGEE} returns a list containing the following elements
\describe{
  \item{\code{result}}{A matrix containing slopes, degrees of freedom, quasilikelihood,
         QIC, delta, and weight values for the set of candidate models.
         The models are ranked by QIC.}
  \item{\code{rvi}}{A vector containing the relative importance of each variable
         in the regression.}

}
}
\description{
mmiGEE is a multimodel inference approach evaluating the relative
importance of predictors used in \code{\link{GEE}}.

 @details It performs automatically
generated model selection and creates a model
selection table according to the approach of multi-model inference
(Burnham & Anderson, 2002). QIC is used to obtain model
selection weights and to rank the models. Moreover, mmiGEE calculates relative
variable importance of a given model.
Finally, this function requires that \strong{all predictor variables
be continuous}.
}
\details{
Calculates the relative importance of each variable
using multi-model inference methods in a Generalized Estimating Equations
framework implemented in \code{GEE}.
}
\examples{
# data (for demonstration only)
library(MASS)
data(birthwt)

# impose an artificial (not fully appropriate) grid structure

x <- rep(1:14, 14)
y <- as.integer(gl(14, 14))
coords <- cbind(x[-(190:196)], y[-(190:196)])

\dontrun{

formula <- formula(low ~ race + smoke +  bwt)

mgee <- GEE(formula,
            family = "gaussian",
            data = birthwt,
            coord = coords,
            corstr = "fixed",
            scale.fix = TRUE)

mmi <- mmiGEE(mgee, birthwt)

}
}
\references{
Burnham, K.P. & Anderson, D.R. (2002) Model selection and
multimodel inference. Springer, New York.

Carl G & Kuehn I, 2007. Analyzing Spatial Autocorrelation in Species
Distributions using Gaussian and Logit Models, Ecol. Model. 207, 159 - 170
}
\seealso{
\code{\link{GEE}}, \code{\link{qic.calc}}, \pkg{MuMIn}
}
\author{
Gudrun Carl, Sam Levin
}
