% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acfft.R
\name{acfft}
\alias{acfft}
\title{Spatial autocorrelation diagnostics}
\usage{
acfft(coord, f, lim1 = 1, lim2 = 2, dmax = 10)
}
\arguments{
\item{coord}{A matrix of two columns with corresponding cartesian
coordinates. Currently only supports integer coordinates.}

\item{f}{A vector which is the same length as \code{x} and \code{y}}

\item{lim1}{Lower bound for first bin. Default is 1}

\item{lim2}{Upper bound for first bin. Default is 2}

\item{dmax}{Number of distance bins to examine. Bins are formed by annuli of gradually
increasing radii. Default is 10.}
}
\value{
A vector of Moran's I values for each distance bin.
}
\description{
A function for calculating spatial autocorrelation using Moran's I.
}
\examples{
data(musdata)
coords <- musdata[ ,4:5]
mglm <- glm(musculus ~ pollution + exposure, "poisson", musdata)

ac <- acfft(coords, resid(mglm, type = "pearson"), lim1 = 0, lim2 = 1)
ac

}
\author{
Gudrun Carl
}
