% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Predict_WRM.R
\name{predict.WRM}
\alias{predict.WRM}
\title{predict.WRM}
\usage{
\method{predict}{WRM}(object, ..., newdata, sm = FALSE, newcoord = NA)
}
\arguments{
\item{object}{A model object of class \code{WRM}}

\item{...}{Other arguments passed to \code{predict}}

\item{newdata}{A data frame containing variables used to make predictions.}

\item{sm}{Logical. Should part of smooth components be included?}

\item{newcoord}{New coordinates corresponding to observations in \code{newdata}.}
}
\value{
A vector of predictions based on a user-specified model
}
\description{
Model predictions for \code{WRM}
}
\examples{
data(musdata)
coords<- musdata[,4:5]

mwrm<-WRM(musculus ~ pollution + exposure, "poisson", musdata,
          coord=coords, level=1, plot=TRUE)
pred<-predict(mwrm,newdata=musdata)

}
\author{
Gudrun Carl,
        Sam Levin
}
