\name{add.distance}
\alias{add.distance}
\alias{add.distance.represampling}
\alias{add.distance.resampling}
\title{Add distance information to resampling objects}
\usage{
  add.distance(object, ...)

  \method{add.distance}{resampling} (object, data,
    coords = c("x", "y"), ...)

  \method{add.distance}{represampling} (object, ...)
}
\arguments{
  \item{object}{\code{\link{resampling}} or
  \code{\link{represampling}} object}

  \item{...}{Additional arguments to
  \code{\link{dataset.distance}} and
  \code{\link{add.distance.resampling}}, respectively}

  \item{data}{\code{data.frame} containing at least the
  columns specified by \code{coords}}

  \item{coords}{(ignored by \code{partition.cv})}
}
\value{
  A \code{\link{resampling}} or \code{\link{represampling}}
  object containing an additional \code{$distance}
  component in each \code{\link{resampling}} object. The
  \code{distance} component is a single numeric value
  indicating, for each \code{train} / \code{test} pair, the
  (by default, mean) nearest-neighbour distance between the
  two sets.
}
\description{
  Add distance information to resampling objects
}
\details{
  Nearest-neighbour distances are calculated for each
  sample in the test set. These \code{nrow(???$test)}
  nearest-neighbour distances are then averaged.
  Aggregation methods other than \code{mean} can be chosen
  using the \code{fun} argument, which will be passed on to
  \code{\link{dataset.distance}}.
}
\examples{
data(ecuador) # Muenchow et al. (2012), see ?ecuador
nsp.parti = partition.cv(ecuador)
sp.parti = partition.kmeans(ecuador)
nsp.parti = add.distance(nsp.parti, ecuador)
sp.parti = add.distance(sp.parti, ecuador)
# non-spatial partioning: very small test-training distance:
nsp.parti[[1]][[1]]$distance
# spatial partitioning: more substantial distance, depending on number of folds etc.
sp.parti[[1]][[1]]$distance
}
\seealso{
  \code{\link{dataset.distance}}
  \code{\link{represampling}} \code{\link{resampling}}
}

