% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R, R/objectSpectraInTime.R
\docType{methods}
\name{getTimePoints}
\alias{getTimePoints}
\alias{getTimePoints,SpectraInTime-method}
\title{generic function to extract \code{timePoints}-slot}
\usage{
getTimePoints(object, ...)

\S4method{getTimePoints}{SpectraInTime}(object, timePointsAlt = FALSE,
  timeUnit = "seconds")
}
\arguments{
\item{object}{a S4 class object}

\item{...}{additional parameters}

\item{timePointsAlt}{logical indicator to get alternative (shifted) instead of recorded time points, defaults to \code{FALSE}}

\item{timeUnit}{unit to use , choose between: \code{seconds} , \code{minutes} or \code{hours}, defaults equal to \code{seconds}}
}
\description{
generic function to extract \code{timePoints}-slot
}
\examples{
 spectra    <-  getSpectraInTimeExample()
 getTimePoints( spectra )
 getTimePoints( spectra , timePointsAlt = TRUE  )
 getTimePoints( spectra , timeUnit = "hours"  )
}
