% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/spectralPreprocessing.R
\docType{methods}
\name{baselineCorrect}
\alias{baselineCorrect}
\alias{baselineCorrect,SpectraInTime-method}
\title{generic function to perfom baseline correction}
\usage{
baselineCorrect(object, ...)

\S4method{baselineCorrect}{SpectraInTime}(object, method = "modpolyfit",
  degree = 4, ...)
}
\arguments{
\item{object}{a S4 class object}

\item{...}{other parameters passed to \code{\link[baseline]{baseline}}}

\item{method}{method of baseline correction, default value is to \code{'modpolyfit'},  see \code{\link[baseline]{baseline.modpolyfit}}}

\item{degree}{numeric value, degree of the polynomial used only if \code{method} is code{'modpolyfit'}}
}
\description{
generic function to perfom baseline correction
}
\note{
baseline correction in the wavelength domain by linking to the \code{\link[baseline]{baseline}}
}
\examples{
 spectralEx           <-  getSpectraInTimeExample()
 plot( spectralEx )   
 timeRange            <-  range( getTimePoints( spectralEx ) )
 timesToSelect        <-  e(  seq( timeRange[1] , timeRange[2] , length.out = 5  )   )
 baselineDefault      <-  baselineCorrect( spectralEx )
 baselineHighPolynomial  <-  baselineCorrect( spectralEx, 
   method = 'modpolyfit', degree = 4 )

 # filtering with fast fourier transform, not so good on example 
 baselineLowpass         <-  baselineCorrect( spectralEx , method = "lowpass" )

 # visual inspection
 plot( baselineDefault[ timesToSelect , ] , type = "time"  )
 plot( baselineHighPolynomial[ timesToSelect , ] , type = "time"  )
 plot( baselineLowpass[ timesToSelect , ] , type = "time"  ) 

}
