% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMR_metabolite_identification.R
\name{choose_nmr_references}
\alias{choose_nmr_references}
\title{Choose the metabolites' spectra to be the reference.}
\description{This function returns the reference spectra, according to the characteristics chosen (frequency, nucleus, solvent, pH and temperature). Only the frequency and nucleus arguments are obligatory.}
\usage{
choose_nmr_references(frequency, nucleus, solvent = NULL, ph = NULL,
  temperature = NULL)
}
\arguments{
\item{frequency}{Frequency of the reference spectra, in Hz. Must either be 400, 500 or 600.}

\item{nucleus}{Atomic nuclei. Possible values: "1H", "13C"}

\item{solvent}{If given, the solvent of the sample. Possbile values: "100\%_DMSO"; "5\%_DMSO"; "acetone+DMSO+tetramethylurea"; "acetone+DMSO+tetramethylurea"; "C"; "CCl4"; "CD3OD"; "CDCl3"; "cyclohexane"; "D2O"; "DMSO-d6"; "DMSO-d6+HCl"; "neat"; "TMS"; "Water".}

\item{ph}{If given, a number corresponding to the sample's pH or a vector of length two indicating a pH interval.}

\item{temperature}{If given, the temperature of the sample, in Celsius. Must either be 25 or 50.}
}
\value{
Returns a list with the reference spectra that have the chosen characteristics. Each spectra is a list with two elements: a list of the chemical shifts and and a list of the respective intensities.
}
\examples{
##Gives all the reference spectra with a frequency of 500 Hz and the nucleus 1H:
ref=choose_nmr_references(500, "1H")
}
