% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{mixediqr}
\alias{mixediqr}
\title{Mixed Interquartile range and semiInterquartile range \code{Walker et al., 2018}}
\usage{
mixediqr(data, var, output, x = 3, pc = FALSE, pcvar = NULL, boot = FALSE)
}
\arguments{
\item{data}{Dataframe or vector where to check outliers.}

\item{var}{Variable to be used for outlier detection if \strong{data} is not a vector file.}

\item{output}{Either \strong{clean}: for clean data output without outliers; \strong{outliers}:
for outlier data frame or vectors.}

\item{x}{A constant for flagging outliers \code{Walker et al., 2018)}.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}
}
\value{
Either clean our outliers
}
\description{
Mixed Interquartile range and semiInterquartile range \code{Walker et al., 2018}
}
\examples{

\donttest{

data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                           lat = 'decimalLatitude', lon= 'decimalLongitude',
                          colsp = "scientificName",
                          bbox = db,
                          minpts = 10)

 logout <- mixediqr(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')

}
}
\references{
Walker ML, Dovoedo YH, Chakraborti S, Hilton CW. 2018. An Improved Boxplot for Univariate Data.
 American Statistician 72:348-353. American Statistical Association.
}
