% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{specification.data.frame}
\alias{specification.data.frame}
\alias{spec}
\title{Make a Specification for a Data Frame}
\usage{
\method{specification}{data.frame}(x, tol = 10, digits = 20, ...)
}
\arguments{
\item{x}{object}

\item{tol}{integer}

\item{digits}{integer}

\item{...}{passed arguments}
}
\value{
spec data.frame with columns as follows.
\describe{
  \item{column}{Column name.}
  \item{label}{A descriptive label. Save and edit as necessary using external tool.}
  \item{guide}{A guide to interpretation.  NA for arbitrary character; range [low:high] for integer and numeric; an encoding e.g. //0/no//1/yes// for factor-like items ... save and edit factor labels as necessary using external tool.

  For numeric ranges you can add text, such as units.  E.g. if default guide is '[0:100]' you can edit to give 'mg [0:100]'.  Or you can just substitute 'mg'.  \code{\link{guidetext}} extracts just the character portion, and \code{\link{matches}} enforces the numeric range.
  }
  \item{required}{An R expression that can be coerced to logical. TRUE means item cannot be NA.}
  \item{comment}{Arbitrary comment, e.g. derivation of the item given by \code{column}.}
}
}
\description{
Makes a specification for data.frame.  Creates a template based on the data.frame. Uses column names for labels where columns do not have a label attribute. Factors will be encoded. numerics will be rounded to \code{digits} and like integers will be expressed as ranges in \code{guide} column. Integers and character with less than or exactly \code{tol} unique values will be encoded.
}
\examples{
data(drug)
file <- tempfile()
spec <- specification(drug, tol = 3)
}
\seealso{
\code{link{read.spec}} \code{\link{write.spec}} \code{\link{respecify.character}} \code{\link{write.spec}} \code{\link{matches}}

Other specification: \code{\link{specification.comment}},
  \code{\link{specification.default}},
  \code{\link{specification}}
}
