% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print_efficiency_criteria}
\alias{print_efficiency_criteria}
\title{Creates a printable version of the efficiency criteria}
\usage{
print_efficiency_criteria(
  iter,
  values,
  criteria,
  digits = 4,
  padding = 10,
  efficiency_criteria
)
}
\arguments{
\item{iter}{An integer giving the iteration of the loop}

\item{values}{The value of the efficiency criteria obtained by
\code{\link{calculate_efficiency_criteria}}}

\item{criteria}{A character string with the name of the efficiency criteria.
See manual for valid values}

\item{digits}{The nubmer of digits to round the printed value to. The default
is 4.}

\item{padding}{An integer specifying the padding of each column element.
Default value is 10.}

\item{efficiency_criteria}{The criteria that we optimize over}
}
\value{
A character string.
}
\description{
The function prints a string of efficiency criteria to the console and
highlights the color of the considered efficiency criteria. Effectively it
is a wrapper around multiple calls to \code{\link{cat}}.
}
