% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random}
\alias{random}
\title{Make a random design}
\usage{
random(
  design_object,
  model,
  efficiency_criteria,
  utility,
  prior_values,
  dudx,
  candidate_set,
  rows,
  control
)
}
\arguments{
\item{design_object}{A list of class 'spdesign' created within the
\code{\link{generate_design}} function}

\item{model}{A character string indicating the model to optimize the design
for. Currently the only model programmed is the 'mnl' model and this is also
set as the default.}

\item{efficiency_criteria}{A character string giving the efficiency criteria
to optimize for. One of 'a-error', 'c-error', 'd-error' or 's-error'. No
default is set and argument must be specified. Optimizing for multiple
criteria is not yet implemented and will result in an error.}

\item{utility}{A named list of utility functions. See the examples and the
vignette for examples of how to define these correctly for different types
of experimental designs.}

\item{prior_values}{A list of priors}

\item{dudx}{A character string giving the name of the parameter in the
denominator. Must be specified when optimizing for 'c-error'}

\item{candidate_set}{A matrix or data frame in the "wide" format containing
all permitted combinations of attributes. The default is NULL. If no
candidate set is provided, then the full factorial subject to specified
exclusions will be used.}

\item{rows}{An integer giving the number of rows in the final design}

\item{control}{A list of control options}
}
\value{
A list of class 'spdesign'
}
\description{
Generates a random design by sampling from the candidate set each update of
the algorithm.
}
\details{
With no restrictions placed, this type of design will only consider efficiency.
There is no guarantee that you will achieve attribute level balance, nor that
all attribute levels will be present. More efficient designs tend to have
more extreme trade-offs.
}
