\name{summary.ppp}
\alias{summary.ppp}
\title{Summary of a Point Pattern Dataset}
\description{
  Prints a useful summary of a point pattern dataset.
}
\usage{
 \method{summary}{ppp}(object, \dots, checkdup=TRUE)
}
\arguments{
  \item{object}{
    Point pattern (object of class \code{"ppp"}).
  }
  \item{\dots}{
    Ignored.
  }
  \item{checkdup}{
    Logical value indicating whether to check
    for the presence of duplicate points.
  }
}
\details{
  A useful summary of the point pattern \code{object} is printed.

  This is a method for the generic function \code{\link{summary}}.

  If \code{checkdup=TRUE}, the pattern will be checked for the
  presence of duplicate points, using \code{\link{duplicated.ppp}}.
  This can be time-consuming if the pattern contains many points,
  so the checking can be disabled by setting \code{checkdup=FALSE}.

  If the point pattern was generated by simulation
  using \code{\link{rmh}}, the parameters of the algorithm
  are printed.
}
\seealso{
  \code{\link{summary}},
  \code{\link{summary.owin}},
  \code{\link{print.ppp}}
}
\examples{
  summary(cells)  # plain vanilla point pattern

  # multitype point pattern
  woods <- lansing
  \testonly{woods <- woods[seq(1, npoints(woods), length=40)]}
  summary(woods) # tabulates frequencies of each mark
  
  # numeric marks
  trees <- longleaf
  \testonly{trees <- trees[seq(1, npoints(trees), length=40)]}
  summary(trees) # prints summary.default(marks(trees))

  # weird polygonal window
  summary(demopat)  # describes it
}
\author{
  Adrian Baddeley \email{Adrian.Baddeley@curtin.edu.au},
 Rolf Turner \email{r.turner@auckland.ac.nz}
 and Ege Rubak \email{rubak@math.aau.dk}
}
\keyword{spatial}
\keyword{methods}

