\name{spatstat.options}
\alias{spatstat.options}
\alias{reset.spatstat.options}
\title{Internal Options in Spatstat Package}
\description{
  Allows the user to examine and reset the values
  of global parameters which control actions in the
  \pkg{spatstat} package.
}
\usage{
  spatstat.options(...)
  reset.spatstat.options()
}
\arguments{
  \item{\dots}{
    Either empty,
    or a succession of parameter names in quotes,
    or a succession of \code{name=value} pairs.
    See below for the parameter names.
  }
}
\value{
  Either a list of parameters and their values,
  or a single value. See Details.
}
\details{
  The function \code{spatstat.options}
  allows the user to examine and reset the values
  of global parameters which control actions in the
  \pkg{spatstat} package.
  It is analogous to the system function \code{\link{options}}.

  The function \code{reset.spatstat.options} resets all the
  global parameters in \pkg{spatstat} to their original,
  default values.
  
  The global parameters are:
  \describe{
    \item{scalable}{
      Logical flag indicating whether the new code in \code{rmh.default}
      which makes the results scalable (invariant to change of units)
      should be used.  In order to recover former behaviour (so that
      previous results can be reproduced) set this option equal to
      \code{FALSE}.  See the \dQuote{Warning} section in the help for
      \code{\link{rmh}()} for more detail.
    }
    \item{npixel}{
      Default number of pixels in a binary mask or pixel image.
      Either an integer, or a pair of integers,
      giving the number of pixels in the \code{x} and \code{y}
      directions respectively.
    }
    \item{maxedgewt}{
      Edge correction weights will be trimmed
      so as not to exceed this value.
      This applies to the weights computed by
      \code{\link{edge.Trans}} or \code{\link{edge.Ripley}}
      and used in \code{\link{Kest}} and its relatives.
    }
    \item{par.binary}{
      List of arguments to be passed to the function \code{\link{image}}
      when displaying a binary image mask (in \code{\link{plot.owin}}
      or \code{\link{plot.ppp}}).
      Typically used to reset the colours of foreground and background.
    }
    \item{par.persp}{
      List of arguments to be passed to the function \code{\link{persp}}
      when displaying a real-valued image, such as the fitted surfaces
      in \code{\link{plot.ppm}}.
    }
    \item{par.points}{
      List of arguments controlling the plotting of point patterns
      by \code{\link{plot.ppp}}.
    }
    \item{par.contour}{
      List of arguments controlling contour plots of pixel images
      by \code{\link{contour.im}}.
    }
    \item{par.fv}{
      List of arguments controlling the plotting of functions 
      by \code{\link{plot.fv}} and its relatives.
    }
    \item{ndummy.min}{
      The minimum number of dummy points in a quadrature scheme
      created by \code{\link{default.dummy}}.
      Either an integer or a pair of integers
      giving the minimum number of dummy points in the \code{x} and \code{y}
      directions respectively. 
    }
    \item{ngrid.disc}{
      Number of points in the square grid used to compute
      a discrete approximation to the areas of discs
      in \code{\link{areaLoss}} and \code{\link{areaGain}}
      when exact calculation is not available.
      A single integer.
    }
    \item{image.colfun}{
      Function determining the default colour map for
      \code{\link{plot.im}}. When called with one integer argument
      \code{n}, this function should return a character vector of length
      \code{n} specifying \code{n} different colours.
    }
    \item{progress}{
      Character string determining the style of progress reports
      printed by \code{\link{progressreport}}. Either
      \code{"tty"} or \code{"txtbar"}.
    }
    \item{checkpolygons}{
      Logical flag indicating whether the functions
      \code{\link{owin}} and \code{\link{as.owin}} should check
      the validity of polygon data. It is advisable to leave this
      set to \code{TRUE}. If you set \code{checkpolygons=FALSE},
      no checking will be performed, making it possible to create
      window objects whose topology is garbled. This can be useful
      for inspecting spatial data that contain errors,
      for example, when converting data from shapefiles.
      However, other functions in \pkg{spatstat} may return
      incorrect answers on these data.
    }
    \item{checksegments}{
      Logical flag indicating whether the functions
      \code{\link{psp}} and \code{\link{as.psp}} should check
      the validity of line segment data (in particular, checking that
      the endpoints of the line segments are inside the specified
      window). It is advisable to leave this flag set to \code{TRUE}. 
    }
    \item{maxmatrix}{
      The maximum permitted size (rows times columns)
      of matrices generated by \pkg{spatstat}'s internal code.
      Used by \code{\link{ppm}} and \code{\link{predict.ppm}}
      (for example) to decide when to
      split a large calculation into blocks.
      Defaults to \code{2^24=16777216}. 
    }
    \item{huge.npoints}{
      The maximum value of \code{n} for which \code{runif(n)} will
      not generate an error (possible errors include failure to allocate
      sufficient memory, and integer overflow of \code{n}).
      An attempt to generate more than this number of random points
      triggers a warning from \code{\link{runifpoint}} and other
      functions. Defaults to \code{1e6}.
    }
    \item{expand}{
      The default expansion factor (area inflation factor)
      for expansion of the simulation window in
      \code{\link{rmh}} (see \code{\link{rmhcontrol}}).
      Initialised to \code{2}.
    }
    \item{fasteval}{
      One of the strings \code{'off'}, \code{'on'} or
      \code{'test'} determining whether to use accelerated C code
      to evaluate the conditional intensity of a Gibbs model.
      Initialised to \code{'on'}.
    }
    \item{density}{
      Logical. Indicates whether to use accelerated C code
      to evaluate \code{density.ppp(X, at="points")}
      Initialised to \code{TRUE}.
    }
    \item{n.bandwidth}{
      Integer. Number of trial values of smoothing bandwidth to use for
      cross-validation in \code{\link{bw.relrisk}} and similar
      functions.
    }
    \item{psstG.remove.zeroes}{
      Logical value, determining whether the algorithm in
      \code{\link{psstG}} 
      removes or retains the contributions to the function
      from pairs of points that are identical. If these are
      retained then the function has a jump at \eqn{r=0}.
      Initialised to \code{TRUE}.
    }
    \item{Kcom.remove.zeroes}{
      Logical value, determining whether the algorithm in
      \code{\link{Kcom}} and \code{\link{Kres}}
      removes or retains the contributions to the function
      from pairs of points that are identical. If these are
      retained then the function has a jump at \eqn{r=0}.
      Initialised to \code{TRUE}.
    }
    \item{psstA.ngrid}{
      Single integer, 
      controlling the accuracy of the discrete approximation
      of areas computed in the function \code{\link{psstA}}.
      The area of a disc is approximated by counting points on
      an \eqn{n \times n}{n * n} grid.
      Initialised to 32.
    }
    \item{psstA.nr}{
      Single integer,
      determining the number of distances \eqn{r}
      at which the function \code{\link{psstA}} will be evaluated
      (in the default case where argument \code{r} is absent).
      Initialised to 30.
    }
    \item{project.fast}{
      Logical. If \code{TRUE}, the algorithm of
      \code{\link{project.ppm}}
      will be accelerated using a shorcut.
      Initialised to \code{FALSE}.
    }
    \item{exactdt.checks.data,closepairs.newcode}{
      Logical. For software development purposes only.
      Do not change these values, unless you are
      Adrian Baddeley. 
    }
    \item{rmh.p, rmh.q, rmh.nrep}{
      New default values for the parameters \code{p}, \code{q}
      and \code{nrep} in the Metropolis-Hastings simulation
      algorithm. These override the defaults
      in \code{\link{rmhcontrol.default}}.
    }
    \item{print.ppm.SE}{
      Default rule used by \code{\link{print.ppm}}
      to decide whether to calculate and print standard errors
      of the estimated coefficients of the model.
      One of the strings \code{"always"}, \code{"never"} or
      \code{"poisson"} (the latter indicating that standard errors
      will be calculated only for Poisson models). The default is
      \code{"poisson"} because the calculation for non-Poisson models
      can take a long time.
    }
    \item{nvoxel}{
      Default number of voxels in a 3D image,
      typically for calculating the distance transform in \code{\link{F3est}}.
      Initialised to 4 megavoxels: \code{nvoxel = 2^22 = 4194304}.
    }
    \item{fastK.lgcp}{
      Logical. Whether to use fast or slow algorithm to compute the
      (theoretical) \eqn{K}-function of a log-Gaussian Cox process
      for use in \code{\link{lgcp.estK}} or \code{\link{Kmodel}}.
      The slow algorithm uses accurate numerical integration; the
      fast algorithm uses Simpson's Rule for numerical integration,
      and is about two orders of magnitude faster.
      Initialised to \code{FALSE}. 
    }
  }
  If no arguments are given, 
  the current values of all parameters are returned,
  in a list.

  If one parameter name is given, the current value of this
  parameter is returned (\bold{not} in a list, just the value).
  
  If several parameter names are given,
  the current values of these parameters are returned, in a list.
  
  If \code{name=value} pairs are given, the named parameters
  are reset to the given values, and the \bold{previous} values of
  these parameters are returned, in a list.
}
\seealso{
  \code{\link{options}}
}
\examples{
  # save current values
  oldopt <- spatstat.options()

  spatstat.options("npixel")
  spatstat.options(npixel=150)
  spatstat.options(npixel=c(100,200))

  spatstat.options(par.binary=list(col=grey(c(0.5,1))))

  spatstat.options(par.persp=list(theta=-30,phi=40,d=4))
  # see help(persp.default) for other options

  # revert
  spatstat.options(oldopt)

}
\author{Adrian Baddeley
  \email{Adrian.Baddeley@csiro.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
