% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choropleth.R
\name{choropleth}
\alias{choropleth}
\title{Create choropleth map}
\usage{
choropleth(
  sf_object,
  value = "output",
  id_name = "areaname",
  mode = "plot",
  n = 7,
  legend_title = "Clustering",
  palette = "viridis"
)
}
\arguments{
\item{sf_object}{object of class sf}

\item{value}{column name to shade the polygons}

\item{id_name}{column name of ids to plot}

\item{mode}{choose between static ('plot' is default) and interactive map ('view')}

\item{n}{number of clusters (default is 7)}

\item{legend_title}{title of legend}

\item{palette}{palette name or a vector of colors. See tmaptools::palette_explorer() for the named palettes. Use a "-" as prefix to reverse the palette. The default palette is "viridis".}
}
\value{
tmap
}
\description{
Takes an object produced by \code{points_to_polygon()}, and creates the corresponding choropleth map.
}
\examples{
test <- points_to_polygon(nl_provincie, insurance, sum(amount, na.rm = TRUE))
choropleth(test)
choropleth(test, id_name = "areaname", mode = "view")
}
\author{
Martin Haringa
}
