% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STclust.R
\name{STclust}
\alias{STclust}
\title{STclust: Detect clusters of spots/cells}
\usage{
STclust(
  x = NULL,
  samples = NULL,
  ws = 0.025,
  dist_metric = "euclidean",
  linkage = "ward.D2",
  ks = "dtc",
  topgenes = 2000,
  deepSplit = FALSE,
  cores = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{an STlist with normalized expression data}

\item{samples}{a vector with strings or a vector with integers indicating the samples
to run STclust}

\item{ws}{a double (0-1) indicating the weight to be applied to spatial distances.
Defaults to 0.025}

\item{dist_metric}{the distance metric to be used. Defaults to 'euclidean'. Other
options are the same as in \code{wordspace::dist.matrix}}

\item{linkage}{the linkage method applied to hierarchical clustering. Passed to
\code{hclust} and defaults to 'ward.D'}

\item{ks}{the range of k values to assess. Defaults to \code{dtc}, meaning \code{cutreeDynamic}
is applied}

\item{topgenes}{the number of genes with highest spot-to-spot expression variation. The
variance is calculated via \code{Seurat::FindVariableFeatures}.}

\item{deepSplit}{a logical or integer (1-4), to be passed to \code{cutreeDynamic} and
control cluster resolution}

\item{cores}{an integer indicating the number of cores to use in parallelization (Unix only)}

\item{verbose}{either logical or an integer (0, 1, or 2) to increase verbosity}
}
\value{
an STlist with cluster assignments
}
\description{
Perform unsupervised spatially-informed clustering on the spots/cells of a
ST sample
}
\details{
The function takes an STlist and calculates euclidean distances between cells or spots
based on the x,y spatial locations, and the expression of the top variable genes
(\code{Seurat::FindVariableFeatures}). The resulting distances are weighted by
applying 1-\code{ws} to the gene expression distances and \code{ws} to the spatial distances.
Hierarchical clustering is performed on the sum of the weighted distance matrices.
The \code{STclust} method allows for identification of tissue niches/domains that are
spatially cohesive.
}
\examples{
\donttest{
# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
unzip(zipfile=zip_tmp, exdir=thrane_tmp)
# Generate the file paths to be passed to the STlist function
count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='counts')
coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                         full.names=TRUE, pattern='mapping')
clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                        full.names=TRUE, pattern='clinical')
# Create STlist
library('spatialGE')
melanoma <- STlist(rnacounts=count_files[c(1,3)], spotcoords=coord_files[c(1,3)], samples=clin_file)
melanoma <- transform_data(melanoma, method='log')
melanoma <- STclust(melanoma, ws=c(0, 0.025))
STplot(melanoma, ws=0.025, samples='ST_mel1_rep2', ptsize=1)
}

}
