% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly_trend.R
\name{poly_trend}
\alias{poly_trend}
\title{Polynomial trend}
\usage{
poly_trend(x, y, degree, ci = 0.95, plot = TRUE, ...)
}
\arguments{
\item{x}{Vector of x}

\item{y}{Vector of y}

\item{degree}{Polynomial order (default 3)}

\item{ci}{+/- confidence interval (default 0.95)}

\item{plot}{Plot results (TRUE/FALSE)}

\item{...}{Additional arguments passed to plot}
}
\value{
A poly.trend class (list) containing
\itemize{
\item trend        data.frame of fit polynomial and upper/lower confidence intervals
\item model        Class lm model object fit with poly term
\item prameterCI   Intercept confidence intervals of Nth order polynomials
\item order        Specified polynomial order
}
}
\description{
Fits a polynomial trend using specified order
}
\note{
A fit using a lm(y ~ x + I(X^2) + I(X^3)) form will be correlated which,
can cause problems. The function avoids undue correlation using orthogonal
polynomials
}
\examples{
 set.seed(42)
 x <- seq(from=0, to=20, by=0.1)
 y <- (500 + 0.4 * (x-10)^3)
 noise <- y + rnorm(length(x), mean=10, sd=80) 
 
 p <- poly_trend(x, noise, degree = 3, ci = 0.95,
                 main="3rd degree polynomial")
 
 dev.new(height=6, width=12)
   layout(matrix(c(1,2), 1, 2, byrow = TRUE))
   p <- poly_trend(x, noise, degree = 3, 
                   main="3rd degree polynomial")
   p <- poly_trend(x, noise, degree = 6, 
                   main="6th degree polynomial")

cat("Confidence intervals for", "1 -", p$order, "polynomials",  "\n")
  p$prameterCI

}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
