% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlap}
\alias{overlap}
\title{Niche overlap (Warren's-I)}
\usage{
overlap(x, y)
}
\arguments{
\item{x}{A matrix or SpatRaster raster class object}

\item{y}{A matrix or SpatRaster raster class object
with the same dimensions of x}
}
\value{
A value representing the I similarity statistic
}
\description{
Similarity Statistic for Quantifying Niche Overlap using Warren's-I

The overlap function computes the I similarity statistic (Warren et al. 2008)  
of two overlapping niche estimates. Similarity is based on the Hellenger distance. 
It is assumed that the input data share the same extent and cellsize and all values 
are positive.

The I similarity statistic sums the pair-wise differences between two
predictions to create a single value representing the similarity of the two
distributions. The I similarity statistic ranges from a value of 0, where
two distributions have no overlap, to 1 where two distributions are
identical (Warren et al., 2008). The function is based on code  
from Jeremy VanDerWal
}
\examples{
  
# add degree of separation in two matrices 
p1 <- abs(matrix(1:50,nr=50,nc=50) + 
         runif(n = 2500, min = -1, max = 1))
p2 <- abs(matrix(1:50,nr=50,nc=50) + 
         rnorm(n = 2500, mean = 1, sd = 1))
 
# High overlap/similarity 
( I <- overlap(p1,p2) ) 

}
\references{
Warren, D. L., R. E. Glor, M. Turelli, and D. Funk. (2008).
  Environmental Niche Equivalency versus Conservatism: Quantitative 
  Approaches to Niche Evolution. Evolution 62:2868-2883.
}
\author{
Jeffrey Evans <jeffrey_evans@tnc.org> and Jeremy VanDerWal
}
