% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{moments}
\alias{moments}
\title{moments}
\usage{
moments(x, plot = FALSE)
}
\arguments{
\item{x}{numeric vector}

\item{plot}{plot of distribution (TRUE/FALSE)}
}
\value{
A vector with the following values:
\itemize{
\item min Minimum
\item 25th  25th percentile
\item mean  Arithmetic mean
\item gmean  Geometric mean
\item hmean  Harmonic mean
\item median  50th percentile
\item 7th5  75th percentile
\item max  Maximum
\item stdv  Standard deviation
\item var  Variance
\item cv  Coefficient of variation (percent)
\item mad  Median absolute deviation
\item skew  Skewness
\item kurt  Kurtosis
\item nmodes  Number of modes
\item mode  Mode (dominate)
}
}
\description{
Calculate statistical moments of a distribution
}
\examples{
    x <- runif(1000,0,100)
    ( d <- moments(x, plot=TRUE) )
    ( mode.x <- moments(x, plot=FALSE)[16] )
 
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
