% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combine}
\alias{combine}
\title{raster combine}
\usage{
combine(x, rnames = NULL, sp = FALSE)
}
\arguments{
\item{x}{raster stack/brick or SpatialPixelsDataFrame object}

\item{rnames}{Column names to combine in raster stack or sp object}

\item{sp}{(FALSE/TRUE) output SpatialPixelsDataFrame}
}
\value{
A  ratified rasterLayer or a list containing a SpatialPixelsDataFrame 
and a data.frame of unique combinations.
}
\description{
Combines rasters into all unique combinations of inputs
}
\details{
Please note that this is not a memory safe function that utilizes
rasters out of memory in the manner that the raster package does.

If sp = TRUE the object will be a list with "combine", containing 
the SpatialPixelsDataFrame with the value attribute containing the 
unique combinations, and "summary" with the summary table of collapsed
combinations and associated attributes.

If sp = FALSE the a single ratified rasterLayer class object is returned 
with the summary table as the raster attribute table, this is most similar
to the ESRI format resulting from their combine function.
}
\examples{
library(raster)

r1 <- raster(nrows=100, ncol=100)
  r1[] <- round(runif(ncell(r1), 1,4),0)
r2 <- raster(nrows=100, ncol=100)
  r2[] <- round(runif(ncell(r2), 2,6),0)
r3 <- raster(nrows=100, ncol=100)
  r3[] <- round(runif(ncell(r3), 2,6),0)
r <- stack(r1,r2,r3)  
  names(r) <- c("LC1","LC2","LC3")

# Combine rasters in stack
( cr <- combine(r) )
  levels(cr)
  
# Combine rasters in stack, using specific rasters
( cr <- combine(r, rnames=c("LC1","LC3")) )

# Combine rasters in stack, output SpatialPixelsDataFrame
cr.sp <- combine(r, sp = TRUE)
  head(cr.sp$summary)
  class(cr.sp$combine)

# Input SpatialPixelsDataFrame 
r.sp <- as(r, "SpatialPixelsDataFrame")
cr.sp <- combine(r.sp, sp = TRUE)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
