% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classBreaks.R
\name{classBreaks}
\alias{classBreaks}
\title{Class breaks}
\usage{
classBreaks(x, n, type = c("equal", "quantile", "std", "geometric"))
}
\arguments{
\item{x}{A vector to find breaks for}

\item{n}{Number of breaks}

\item{type}{Statistic used to find breaks c("equal", "quantile", "std", "geometric")}
}
\value{
A vector containing class break values the length is n+1 to allow for 
        specification of ranges
}
\description{
Finds class breaks in a distribution
}
\note{
The robust std method uses sqrt(sum(x^2)/(n-1)) to center the data before 
      deriving "pretty" breaks.
}
\examples{
 y <- rnbinom(100, 10, 0.5)
   classBreaks(y, 10)  
   classBreaks(y, 10, type="quantile")
 
opar <- par(no.readonly=TRUE)
   par(mfrow=c(2,2))
     d <- density(y)
     plot(d, type="n", main="Equal Area breaks")
       polygon(d, col="cyan")
       abline(v=classBreaks(y, 10)) 
     plot(d, type="n", main="Quantile breaks")
       polygon(d, col="cyan")
       abline(v=classBreaks(y, 10, type="quantile"))
     plot(d, type="n", main="Robust Standard Deviation breaks")
       polygon(d, col="cyan")
       abline(v=classBreaks(y, 10, type="std"))
     plot(d, type="n", main="Geometric interval breaks")
       polygon(d, col="cyan")
       abline(v=classBreaks(y, 10, type="geometric"))
 par(opar)
	
 ( y.breaks <- classBreaks(y, 10) )   	
 cut(y, y.breaks, include.lowest = TRUE, labels = 1:10)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
