% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlogram.R
\name{correlogram}
\alias{correlogram}
\title{Correlogram}
\usage{
correlogram(x, v, dist = 5000, dmatrix = FALSE, ns = 99, latlong = FALSE, ...)
}
\arguments{
\item{x}{SpatialPointsDataFrame object}

\item{v}{Test variable in x@data}

\item{dist}{Distance of correlation lags, if latlong=TRUE units are in kilometers}

\item{dmatrix}{Should the distance matrix be include in output (TRUE/FALSE)}

\item{ns}{Number of simulations to derive simulation envelope}

\item{latlong}{Coordinates are in latlong (TRUE/FALSE)}

\item{...}{Arguments passed to cor ('pearson', 'kendall' or 'spearman')}
}
\value{
A list object containing:

autocorrelation is a data.frame object with the following components

autocorrelation - Autocorrelation value for each distance lag

dist - Value of distance lag

lci - Lower confidence interval (p=0.025)

uci - Upper confidence interval (p=0.975)

CorrPlot recordedplot object to recall plot

dmatrix Distance matrix (if dmatrix=TRUE)
}
\description{
Calculates and plots a correlogram
}
\note{
depends: sp
}
\examples{
library(sp)
data(meuse)
coordinates(meuse) = ~x+y
zinc.cg <- correlogram(x = meuse, v = meuse@data[,'zinc'], dist = 250, ns = 9)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
