% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.distance.R
\name{subsample.distance}
\alias{subsample.distance}
\title{Subsample distances}
\usage{
subsample.distance(x, n, d, d.max = NULL, replacement = FALSE,
  latlong = FALSE, trace = FALSE)
}
\arguments{
\item{x}{A spatial polygons or points sp object}

\item{n}{Number of random samples drawn from x}

\item{d}{Minimum sample distance}

\item{d.max}{Maximum sample distance (not used unless specified}

\item{replacement}{(FALSE/TRUE) sample with or without replacement}

\item{latlong}{(FALSE/TRUE) is the data in a geographic projection (latitude/longitude)}

\item{trace}{(FALSE/TRUE) Print min and max sample distances}
}
\value{
A sp spatial object, of the same class as x containing the random sub-samples
}
\description{
Minimum, and optional maximum, distance constrained sub-sampling
}
\note{
This function provides a distance constrained subsample of existing point or polygon data
}
\examples{
  library(sp)
  data(meuse)
    coordinates(meuse) <- ~ x+y
  
  # Subsample with a 500m minimum sample spread 
  sub.meuse <- subsample.distance(meuse, n = 10, d = 500, trace = TRUE)  
    plot(meuse,pch=19, main="min dist = 500")
      points(sub.meuse, pch=19, col="red") 
  
  # Check distances	
  dm <- spDists(sub.meuse)
    diag(dm) <- NA
  cat("\\n", "Min distance for subsample", min(dm, na.rm=TRUE), "\\n")  
  cat("Max distance for subsample", max(dm, na.rm=TRUE), "\\n")  
    
\dontrun{
  # Subsample with a 500m minimum and 3500m maximum sample spread   
  sub.meuse <- subsample.distance(meuse, n = 10, d = 500, d.max = 3500)  
    plot(meuse,pch=19, main="min dist = 500, max dist = 3500")
      points(sub.meuse, pch=19, col="red") 

  # Check distances		
  dm <- spDists(sub.meuse)
    diag(dm) <- NA
  cat("Min distance for subsample", min(dm, na.rm=TRUE), "\\n")  
  cat("Max distance for subsample", max(dm, na.rm=TRUE), "\\n")    
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
