% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srr.R
\name{srr}
\alias{srr}
\title{Surface Relief Ratio}
\usage{
srr(x, s = 5, ...)
}
\arguments{
\item{x}{raster object}

\item{s}{Focal window size}

\item{...}{Additional arguments passed to raster::calc}
}
\value{
raster class object of Pike's (1971) Surface Relief Ratio
}
\description{
Calculates the Pike (1971) Surface Relief Ratio
}
\note{
Describes rugosity in continuous raster surface within a specified window. The implementation of SRR can be shown as: 
(mean(x) - min(x)) / (max(x) - min(x))
}
\examples{
  library(raster)
  data(elev)
  r.srr <- srr(elev, s=5)
    plot(r.srr, main="Surface Relief Ratio") 
    
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
