% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daymet.point.R
\name{daymet.point}
\alias{daymet.point}
\title{DAYMET point values}
\usage{
daymet.point(lat, long, start.year, end.year, site, clean.up = TRUE,
  echo = FALSE)
}
\arguments{
\item{lat}{latitude of point (decimal degrees WGS84)}

\item{long}{longitude pf point (decimal degrees WGS84)}

\item{start.year}{First year of data}

\item{end.year}{Last year of data}

\item{site}{Unique identification value that is appended to data}

\item{clean.up}{(TRUE/FALSE) Delete downloaded csv files on disk}

\item{echo}{(TRUE/FALSE) Echo progress}
}
\value{
A data.frame with climate results
}
\description{
Downloads DAYMET climate variables for specified point and timeperiod
}
\note{
Function uses the Single Pixel Extraction tool and returns year, yday, dayl(s), prcp (mm/day), srad (W/m^2), swe (kg/m^2), tmax (deg c), tmin (deg c), vp (Pa)

Metadata for DAYMET single pixel extraction: \url{ https://daymet.ornl.gov/files/UserGuides/current/readme_singlepointextraction.pdf }
}
\examples{
\dontrun{
( d <- daymet.point(lat = 36.0133, long = -84.2625, start.year = 2013, end.year=2014, 
                    site = "1", clean.up = TRUE, echo = FALSE) )
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

