% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/logistic.regression.R
\name{logistic.regression}
\alias{logistic.regression}
\title{Logistic and Auto-logistic regression}
\usage{
logistic.regression(ldata, y, x, penalty = TRUE, autologistic = FALSE,
  coords = NULL, bw = NULL, type = "inverse", style = "W",
  longlat = FALSE, ...)
}
\arguments{
\item{ldata}{data.frame object contaning variables}

\item{y}{Dependent variable (y) in ldata}

\item{x}{Independent variable(s) (x) in ldata}

\item{penalty}{Apply regression penelty (TRUE/FALSE)}

\item{autologistic}{Add auto-logistic term (TRUE/FALSE)}

\item{coords}{Geographic coordinates for auto-logistc model}

\item{bw}{Distance bandwidth to calculate spatial lags (if empty neighbors result, need to increase bandwith)}

\item{type}{Neighbor weighting scheme (see autocov_dist)}

\item{style}{Type of neighbor matrix (Wij), default is mean of neighbors}

\item{longlat}{Are coordinates (coords) in geographic, lat/long (TRUE/FALSE)}

\item{...}{Additional arguments passed to lrm}
}
\value{
A list class object with the following components:

model lrm model object (rms class)

diagTable data.frame of regression diagnostics

coefTable data.frame of regression coefficents

Residuals data.frame of residuals and standardized residuals

AutoCov If an auto-logistic model, AutoCov represents lagged auto-covariance term
}
\description{
Performs a logistic (binomial) and auto-logistic (spatially lagged binomial) regression
}
\note{
Spatially lagged y defined as:

W(y)ij=sumj_(Wij yj)/ sumj_(Wij)

where; Wij=1/Euclidian[i,j]

depends: rms, spdep
}
\examples{
require(sp)
require(spdep)
require(rms)
data(meuse)
  coordinates(meuse) <- ~x+y
    meuse@data <- data.frame(DepVar=rbinom(dim(meuse)[1], 1, 0.5), meuse@data)

#### Logistic model
lmodel <- logistic.regression(meuse@data, y='DepVar', x=c('dist','cadmium','copper'))
  lmodel$model
    lmodel$diagTable
      lmodel$coefTable

### Auto-logistic model using 'autocov_dist' in 'spdep' package
lmodel <- logistic.regression(meuse@data, y='DepVar', x=c('dist','cadmium','copper'),
                              autologistic=TRUE, coords=coordinates(meuse), bw=5000)
  lmodel$model
    lmodel$diagTable
      lmodel$coefTable
  est <- predict(lmodel$model, type='fitted.ind')

#### Add residuals, standardized residuals and estimated probabilities
VarNames <- rownames(lmodel$model$var)[-1]
  meuse@data$AutoCov <- lmodel$AutoCov
    meuse@data <- data.frame(meuse@data, Residual=lmodel$Residuals[,1],
                             StdResid=lmodel$Residuals[,2], Probs=predict(lmodel$model,
                             meuse@data[,VarNames],type='fitted') )

#### Plot fit and probabilities
resid(lmodel$model, "partial", pl="loess")
resid(lmodel$model, "partial", pl=TRUE)                 # plot residuals
resid(lmodel$model, "gof")                              # global test of goodness of fit
lp1 <- resid(lmodel$model, "lp1")                       # Approx. leave-out linear predictors
-2 * sum(meuse@data$DepVar * lp1 + log(1-plogis(lp1))) # Approx leave-out-1 deviance
spplot(meuse, c('Probs'))                               # plot estimated probs at points
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
\references{
Le Cessie S, Van Houwelingen JC (1992) Ridge estimators in logistic regression. Applied Statistics 41:191-201

Shao J (1993) Linear model selection by cross-validation. JASA 88:486-494
}

