% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacejamr.R
\name{as.spacejamr}
\alias{as.spacejamr}
\title{Initialize a new spacejamr object}
\usage{
as.spacejamr(path, guess_crs = TRUE)
}
\arguments{
\item{path}{the path to a shapefile as a string.}

\item{guess_crs}{whether to try to guess the coordinate reference system of
the supplied shapefile}
}
\value{
a spacejamr object containing two items. window: object of class
'owin' that stores geographical boundaries. crs: integer value referring to
the coordinate reference system of the geographical boundaries.
}
\description{
Creates a new spacejamr object that for further analysis
}
\details{
The returned spacejamr object will contain a window object
containing a geographical boundary and its coordinate reference system.
Since any simulated point process will be simulated in two dimensions, the
coordinate reference system of the supplied shapefile should be a projected
coordinate reference system or 'guess_crs' should be set to TRUE. In that
case, the coordinate reference system will be set to the most appropriate
coordinate reference system for the shapefile. Note that guessing the
coordinate reference system will take longer than if one is already set.
}
\examples{
\donttest{
ri <- as.spacejamr(system.file("shape/ri.shp", package = "spacejamr"))
}

}
\author{
Darren Colby \cr
Email: dscolby@gmail.com
}
