% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solr_get.R
\name{solr_get}
\alias{solr_get}
\title{Real time get}
\usage{
solr_get(ids, name, fl = NULL, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{ids}{Document IDs, one or more in a vector or list}

\item{name}{(character) A collection or core name. Required.}

\item{fl}{Fields to return, can be a character vector like \code{c('id', 'title')},
or a single character vector with one or more comma separated names, like
\code{'id,title'}}

\item{wt}{(character) One of json (default) or xml. Data type returned.
If json, uses \code{\link[jsonlite]{fromJSON}} to parse. If xml, uses
\code{\link[xml2]{read_xml}} to parse.}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{...}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Get documents by id
}
\details{
We use json internally as data interchange format for this function.
}
\examples{
\dontrun{
solr_connect()

# add some documents first
ss <- list(list(id = 1, price = 100), list(id = 2, price = 500))
add(ss, name = "gettingstarted")

# Now, get documents by id
solr_get(ids = 1, "gettingstarted")
solr_get(ids = 2, "gettingstarted")
solr_get(ids = c(1, 2), "gettingstarted")
solr_get(ids = "1,2", "gettingstarted")

# Get raw JSON
solr_get(ids = 1, "gettingstarted", raw = TRUE, wt = "json")
solr_get(ids = 1, "gettingstarted", raw = TRUE, wt = "xml")
}
}

