% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothic_functions.R
\name{smoothic}
\alias{smoothic}
\title{Variable Selection Using a Smooth Information Criterion (SIC)}
\usage{
smoothic(
  formula,
  data,
  family = "sgnd",
  model = "mpr",
  lambda = "log(n)",
  epsilon_1 = 10,
  epsilon_T = 1e-04,
  steps_T = 100,
  zero_tol = 1e-05,
  max_it = 10000,
  optimizer = "nlm",
  kappa,
  tau,
  stepmax_nlm
)
}
\arguments{
\item{formula}{An object of class \code{"\link{formula}"}: a two-sided object
with response on the left hand side and the model variables on the right hand side.}

\item{data}{A data frame containing the variables in the model; the data frame
should be unstandardized.}

\item{family}{The family of the model, default is \code{family = "sgnd"} for the
"Smooth Generalized Distribution" where the shape parameter kappa is also
estimated. Classical regression with normally distributed errors is performed
when \code{family = "normal"}. If \code{family = "laplace"}, this corresponds to
a robust regression with errors from the Laplace distribution.}

\item{model}{The type of regression to be implemented, either \code{model = "mpr"}
for multi-parameter regression, or \code{model = "spr"} for single parameter
regression (i.e., classical normal linear regression). Defaults to \code{model="mpr"}.}

\item{lambda}{Value of penalty tuning parameter. Suggested values are
\code{"log(n)"} and \code{"2"} for the BIC and AIC respectively. Defaults to
\code{lambda ="log(n)"} for the BIC case.}

\item{epsilon_1}{Starting value for \eqn{\epsilon}-telescope. Defaults to 10.}

\item{epsilon_T}{Final value for \eqn{\epsilon}-telescope. Defaults to
\code{1e-04}.}

\item{steps_T}{Number of steps in \eqn{\epsilon}-telescope. Defaults to 100.}

\item{zero_tol}{Coefficients below this value are treated as being zero.
Defaults to \code{1e-05}.}

\item{max_it}{Maximum number of iterations to be performed before the
optimization is terminated. Defaults to \code{1e+04}.}

\item{optimizer}{The optimization procedure to be used. Defaults to
\code{optimizer = "nlm"}, where the \code{\link{nlm}} function from the
\bold{stats} package is used. This tends to be more stable than the manually
 coded Newton-Raphson procedure that is used when \code{optimizer = "manual"}.}

\item{kappa}{Optional user-supplied positive kappa value (> 0.2 to avoid
computational issues) if \code{family = "sgnd"}. If supplied, the shape parameter
kappa will be fixed to this value in the optimization. If not supplied, kappa is
estimated from the data.}

\item{tau}{Optional user-supplied positive smoothing parameter value in the
"Smooth Generalized Normal Distribution" if \code{family = "sgnd"} or
\code{family = "laplace"}. If not supplied, then \code{tau = "0.15"}.
Smaller values of \code{tau} bring the approximation closer to the absolute value
function, but this can cause the optimization to become unstable. Some issues with
standard error calculation with smaller values of \code{tau} when using the Laplace
distribution in the robust regression setting.}

\item{stepmax_nlm}{Optional maximum allowable scaled step length (positive scalar) to be passed to
\code{\link{nlm}} if \code{optimizer = "nlm"}. If not supplied, default values in
\code{\link{nlm}} are used.}
}
\value{
A list with estimates and estimated standard errors.
\itemize{
  \item \code{coefficients} - vector of coefficients.
  \item \code{see} - vector of estimated standard errors.
  \item \code{model} - the matched type of model which is called.
  \item \code{plike} - value of the penalized likelihood function.
  \item \code{kappa} - value of the estimated/fixed shape parameter kappa if \code{family = "sgnd"}.
  }
}
\description{
Implements the SIC \eqn{\epsilon}-telescope method, either using
single or multi-parameter regression. Returns estimated coefficients, estimated
standard errors (SEE) and the value of the penalized likelihood function.
Note that the function will scale the predictors to have unit variance, however,
the final estimates are converted back to their original scale.
}
\examples{
# Sniffer Data --------------------
# MPR Model ----
results <- smoothic(
  formula = y ~ .,
  data = sniffer,
  family = "normal",
  model = "mpr"
)
summary(results)
}
\references{
O'Neill, M. and Burke, K. (2021) Variable Selection Using a Smooth
Information Criterion for Multi-Parameter Regression Models. <arXiv:2110.02643>

O'Neill, M. and Burke, K. (2022) Robust Distributional Regression with
Automatic Variable Selection. <arXiv:2212.07317>
}
\author{
Meadhbh O'Neill
}
