% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oesg.R
\name{oesg}
\alias{oesg}
\title{Occurrence ETS, general model}
\usage{
oesg(y, modelA = "MNN", modelB = "MNN", persistenceA = NULL,
  persistenceB = NULL, phiA = NULL, phiB = NULL, initialA = "o",
  initialB = "o", initialSeasonA = NULL, initialSeasonB = NULL,
  ic = c("AICc", "AIC", "BIC", "BICc"), h = 10, holdout = FALSE,
  interval = c("none", "parametric", "likelihood", "semiparametric",
  "nonparametric"), level = 0.95, bounds = c("usual", "admissible", "none"),
  silent = c("all", "graph", "legend", "output", "none"), xregA = NULL,
  xregB = NULL, initialXA = NULL, initialXB = NULL, xregDoA = c("use",
  "select"), xregDoB = c("use", "select"), updateXA = FALSE,
  updateXB = FALSE, transitionXA = NULL, transitionXB = NULL,
  persistenceXA = NULL, persistenceXB = NULL, ...)
}
\arguments{
\item{y}{Either numeric vector or time series vector.}

\item{modelA}{The type of the ETS for the model A.}

\item{modelB}{The type of the ETS for the model B.}

\item{persistenceA}{The persistence vector \eqn{g}, containing smoothing
parameters used in the model A. If \code{NULL}, then estimated.}

\item{persistenceB}{The persistence vector \eqn{g}, containing smoothing
parameters used in the model B. If \code{NULL}, then estimated.}

\item{phiA}{The value of the dampening parameter in the model A. Used only
for damped-trend models.}

\item{phiB}{The value of the dampening parameter in the model B. Used only
for damped-trend models.}

\item{initialA}{Either \code{"o"} - optimal or the vector of initials for the
level and / or trend for the model A.}

\item{initialB}{Either \code{"o"} - optimal or the vector of initials for the
level and / or trend for the model B.}

\item{initialSeasonA}{The vector of the initial seasonal components for the
model A. If \code{NULL}, then it is estimated.}

\item{initialSeasonB}{The vector of the initial seasonal components for the
model B. If \code{NULL}, then it is estimated.}

\item{ic}{Information criteria to use in case of model selection.}

\item{h}{Forecast horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{interval}{Type of interval to construct. This can be:

\itemize{
\item \code{"none"}, aka \code{"n"} - do not produce prediction
interval.
\item \code{"parametric"}, \code{"p"} - use state-space structure of ETS. In
case of mixed models this is done using simulations, which may take longer
time than for the pure additive and pure multiplicative models. This type
of interval relies on unbiased estimate of in-sample error variance, which
divides the sume of squared errors by T-k rather than just T.
\item \code{"likelihood"}, \code{"l"} - these are the same as \code{"p"}, but
relies on the biased estimate of variance from the likelihood (division by
T, not by T-k).
\item \code{"semiparametric"}, \code{"sp"} - interval based on covariance
matrix of 1 to h steps ahead errors and assumption of normal / log-normal
distribution (depending on error type).
\item \code{"nonparametric"}, \code{"np"} - interval based on values from a
quantile regression on error matrix (see Taylor and Bunn, 1999). The model
used in this process is e[j] = a j^b, where j=1,..,h.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. The former means that
parametric interval are constructed, while the latter is equivalent to
\code{none}.
If the forecasts of the models were combined, then the interval are combined
quantile-wise (Lichtendahl et al., 2013).}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{xregA}{The vector or the matrix of exogenous variables, explaining some parts
of occurrence variable of the model A.}

\item{xregB}{The vector or the matrix of exogenous variables, explaining some parts
of occurrence variable of the model B.}

\item{initialXA}{The vector of initial parameters for exogenous variables in the model
A. Ignored if \code{xregA} is NULL.}

\item{initialXB}{The vector of initial parameters for exogenous variables in the model
B. Ignored if \code{xregB} is NULL.}

\item{xregDoA}{Variable defines what to do with the provided \code{xregA}:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done.}

\item{xregDoB}{Similar to the \code{xregDoA}, but for the part B of the model.}

\item{updateXA}{If \code{TRUE}, transition matrix for exogenous variables is
estimated, introducing non-linear interactions between parameters.
Prerequisite - non-NULL \code{xregA}.}

\item{updateXB}{If \code{TRUE}, transition matrix for exogenous variables is
estimated, introducing non-linear interactions between parameters.
Prerequisite - non-NULL \code{xregB}.}

\item{transitionXA}{The transition matrix \eqn{F_x} for exogenous variables of the model A.
Can be provided as a vector. Matrix will be formed using the default
\code{matrix(transition,nc,nc)}, where \code{nc} is number of components in
state vector. If \code{NULL}, then estimated. Prerequisite - non-NULL
\code{xregA}.}

\item{transitionXB}{The transition matrix \eqn{F_x} for exogenous variables of the model B.
Similar to the \code{transitionXA}.}

\item{persistenceXA}{The persistence vector \eqn{g_X}, containing smoothing
parameters for the exogenous variables of the model A. If \code{NULL}, then estimated.
Prerequisite - non-NULL \code{xregA}.}

\item{persistenceXB}{The persistence vector \eqn{g_X}, containing smoothing
parameters for the exogenous variables of the model B. If \code{NULL}, then estimated.
Prerequisite - non-NULL \code{xregB}.}

\item{...}{The parameters passed to the optimiser, such as \code{maxeval},
\code{xtol_rel}, \code{algorithm} and \code{print_level}. The description of
these is printed out by \code{nloptr.print.options()} function from the \code{nloptr}
package. The default values in the oes function are \code{maxeval=500},
\code{xtol_rel=1E-8}, \code{algorithm="NLOPT_LN_SBPLX"} and \code{print_level=0}.}
}
\value{
The object of class "occurrence" is returned. It contains following list of
values:

\itemize{
\item \code{modelA} - the model A of the class oes, that contains the output similar
to the one from the \code{oes()} function;
\item \code{modelB} - the model B of the class oes, that contains the output similar
to the one from the \code{oes()} function.
\item \code{B} - the vector of all the estimated parameters.
}
}
\description{
Function returns the general occurrence model of the of iETS model.
}
\details{
The function estimates probability of demand occurrence, based on the iETS_G
state-space model. It involves the estimation and modelling of the two
simultaneous state space equations. Thus two parts for the model type,
persistence, initials etc.

For the details about the model and its implementation, see the respective
vignette: \code{vignette("oes","smooth")}

The model is based on:

\deqn{o_t \sim Bernoulli(p_t)}
\deqn{p_t = \frac{a_t}{a_t+b_t}},

where a_t and b_t are the parameters of the Beta distribution and are modelled
using separate ETS models.
}
\examples{

y <- rpois(100,0.1)
oesg(y, modelA="MNN", modelB="ANN")

}
\seealso{
\code{\link[smooth]{es}, \link[smooth]{oes}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{demand}
\keyword{exponential}
\keyword{forecasting}
\keyword{intermittent}
\keyword{iss}
\keyword{model}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{smoothing}
\keyword{space}
\keyword{state}
\keyword{ts}
\keyword{univar}
