% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simces.R
\name{sim.ces}
\alias{sim.ces}
\title{Simulate Complex Exponential Smoothing}
\usage{
sim.ces(seasonality = c("none", "simple", "partial", "full"), obs = 10,
  nsim = 1, frequency = 1, A = NULL, B = NULL, initial = NULL,
  randomizer = c("rnorm", "rt", "rlaplace", "rs"), iprob = 1, ...)
}
\arguments{
\item{seasonality}{The type of seasonality used in CES. Can be: \code{none}
- No seasonality; \code{simple} - Simple seasonality, using lagged CES
(based on \code{t-m} observation, where \code{m} is the seasonality lag);
\code{partial} - Partial seasonality with real seasonal components
(equivalent to additive seasonality); \code{full} - Full seasonality with
complex seasonal components (can do both multiplicative and additive
seasonality, depending on the data). First letter can be used instead of
full words.  Any seasonal CES can only be constructed for time series
vectors.}

\item{obs}{Number of observations in each generated time series.}

\item{nsim}{Number of series to generate (number of simulations to do).}

\item{frequency}{Frequency of generated data. In cases of seasonal models
must be greater than 1.}

\item{A}{First complex smoothing parameter. Should be a complex number.

NOTE! CES is very sensitive to A and B values so it is advised to use values
from previously estimated model.}

\item{B}{Second complex smoothing parameter. Can be real if
\code{seasonality="partial"}. In case of \code{seasonality="full"} must be
complex number.}

\item{initial}{A matrix with initial values for CES. In case with
\code{seasonality="partial"} and \code{seasonality="full"} first two columns
should contain initial values for non-seasonal components, repeated
\code{frequency} times.}

\item{randomizer}{Type of random number generator function used for error
term. Defaults are: \code{rnorm}, \code{rt}, \code{rlaplace} and \code{rs}.
\code{rlnorm} should be used for multiplicative models (e.g. ETS(M,N,N)).
But any function from \link[stats]{Distributions} will do the trick if the
appropriate parameters are passed. For example \code{rpois} with
\code{lambda=2} can be used as well, but might result in weird values.}

\item{iprob}{Probability of occurrence, used for intermittent data
generation. This can be a vector, implying that probability varies in time
(in TSB or Croston style).}

\item{...}{Additional parameters passed to the chosen randomizer. All the
parameters should be passed in the order they are used in chosen randomizer.
For example, passing just \code{sd=0.5} to \code{rnorm} function will lead
to the call \code{rnorm(obs, mean=0.5, sd=1)}.}
}
\value{
List of the following values is returned:
\itemize{
\item \code{model} - Name of CES model.
\item \code{A} - Value of complex smoothing parameter A. If \code{nsim>1}, then
this is a vector.
\item \code{B} - Value of complex smoothing parameter B. If \code{seasonality="n"}
or \code{seasonality="s"}, then this is equal to NULL. If \code{nsim>1},
then this is a vector.
\item \code{initial} - Initial values of CES in a form of matrix. If \code{nsim>1},
then this is an array.
\item \code{data} - Time series vector (or matrix if \code{nsim>1}) of the generated
series.
\item \code{states} - Matrix (or array if \code{nsim>1}) of states. States are in
columns, time is in rows.
\item \code{residuals} - Error terms used in the simulation. Either vector or matrix,
depending on \code{nsim}.
\item \code{occurrences} - Values of occurrence variable. Once again, can be either
a vector or a matrix...
\item \code{logLik} - Log-likelihood of the constructed model.
}
}
\description{
Function generates data using CES with Single Source of Error as a data
generating process.
}
\examples{

# Create 120 observations from CES(n). Generate 100 time series of this kind.
x <- sim.ces("n",obs=120,nsim=100)

# Generate similar thing for seasonal series of CES(s)_4
x <- sim.ces("s",frequency=4,obs=80,nsim=100)

# Estimate model and then generate 10 time series from it
ourModel <- ces(rnorm(100,100,5))
simulate(ourModel,nsim=10)

}
\references{
\itemize{
\item Svetunkov, I., Kourentzes, N. (February 2015). Complex exponential
smoothing. Working Paper of Department of Management Science, Lancaster
University 2015:1, 1-31.
\item Svetunkov I., Kourentzes N. (2017) Complex Exponential Smoothing
for Time Series Forecasting. Not yet published.
}
}
\seealso{
\code{\link[smooth]{sim.es}, \link[smooth]{sim.ssarima},
\link[smooth]{ces}, \link[stats]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
