% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sai.R
\name{weight_mat}
\alias{weight_mat}
\alias{w_col}
\alias{build_w}
\alias{est_w}
\alias{var_w}
\title{Building weight matrix \strong{W} for Areal Interpolation}
\usage{
w_col(source_unit, target)

build_w(source, target)

est_w(W, source_dt, target)

var_w(W, var_vec, target, method = "CS", rho_mi)
}
\arguments{
\item{source_unit}{a single \code{geometry} from the source dataset.}

\item{target}{a \code{sf} object - target spatial data.}

\item{source}{a \code{sf} object - source spatial data.}

\item{W}{the weight matrix.}

\item{source_dt}{a \code{data.frame} object representing the source dataset
but excludying the \code{geometry}, i.e. the spatial information,
column.}

\item{var_vec}{a \code{numeric} vector with variances observed at the source
data.}

\item{method}{a \code{character} representing the method to approximate the
variance of the AI estimates. Possible values are "CS"
(Cauchy-Schwartz) or "MI" (Moran's I).}

\item{rho_mi}{\code{numeric} calcuated Moran's I.}
}
\value{
A \eqn{n \times m} \code{numeric} matrix. Where \eqn{n} is the
number of objservations in the target and \eqn{m} is the sample size in
the source dataset.
}
\description{
internal use. \eqn{W_{ij} = | A_i \, cap \, B_j |}.
}
\keyword{internal}
