% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem.lme.R
\name{semLme}
\alias{semLme}
\title{Linear Mixed Regression with Interval-Censored Dependent Variable}
\usage{
semLme(
  formula,
  data,
  classes,
  burnin = 40,
  samples = 200,
  trafo = "None",
  adjust = 2,
  bootstrap.se = FALSE,
  b = 100
)
}
\arguments{
\item{formula}{a two-sided linear formula object describing both the fixed-effects
and random-effects part of the model, with the response on the left of a ~ operator
and the terms, separated by + operators, on the right. Random-effects terms are
distinguished by vertical bars (|) separating expressions for design matrices from
grouping factors, as in \code{\link[lme4]{lmer}}. Note: Only models with a
maximum of one random intercept
and one random slope are implemented at this point (e.g. \code{y ~ x + (1|
ID)}, or \code{y ~ x + (x|ID)}). The
dependent variable is measured as interval-censored values; factor with
ordered factor values}

\item{data}{a data frame containing the variables of the model}

\item{classes}{numeric vector of classes; \code{-Inf} as lower interval bound and
\code{Inf} as upper interval bound
is allowed. If the Box-Cox or
logarithmic transformation is chosen, the minimum interval bound must be
\eqn{\ge 0}.}

\item{burnin}{the number of burn-in iterations of the SEM-algorithm}

\item{samples}{the number of additional iterations of the SEM-algorithm
for parameter estimation}

\item{trafo}{transformation of the dependent variable to fulfil the model assumptions
  \itemize{
  \item "log" for Logarithmic transformation
  \item "bc" for Box-Cox transformation
}
default is \code{"None"}. Transformations can only be used if the minimum
interval bound is \eqn{\ge 0}.}

\item{adjust}{extends the number of iteration steps of the SEM-algorithm
for finding the optimal lambda of the Box-Cox transformation. The number of iterations
is extended in the following way: \code{(burnin+samples)*adjust}}

\item{bootstrap.se}{if \code{TRUE} standard errors of the regression parameters
are estimated}

\item{b}{number of bootstrap iterations for the estimation of the standard errors}
}
\value{
An object of class "sem" that provides parameter estimated for linear
regression models with interval-censored dependent variable. Generic
functions such as, \code{\link{print}},
\code{\link{plot}}, and \code{\link{summary}} have methods that can be used
to obtain further information. See \code{\link{semObject}} for descriptions
of components
of objects of class "sem".
}
\description{
This function estimates the linear mixed regression model when
the dependent
variable is interval-censored. The estimation of the standard errors is
fasciliated by a parametric bootstrap.
}
\details{
The model parameters are estimated using pseudo samples of the
interval-censored dependent variable. The object \code{pseudo.y} returns the
pseudo samples of each iteration step of the SEM-algorithm.
}
\examples{
\dontrun{
# Load and prepare data
data <- Exam
classes <- c(1, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5, 7.7, 8.5, Inf)
data$examsc.class <- cut(data$examsc, classes)

# Run model with random intercept and default settings
model1 <- semLme(
  formula = examsc.class ~ standLRT + schavg + (1 | school),
  data = data, classes = classes
)
summary(model1)

}
\dontshow{
# Load and prepare data
data <- Exam
classes <- c(1, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5, 7.7, 8.5, Inf)
data$examsc.class <- cut(data$examsc, classes)

# Run model with random intercept and default settings
model1 <- semLme(
  formula = examsc.class ~ standLRT + schavg + (1 | school),
  data = data, classes = classes, burnin = 4, samples = 10
)
summary(model1)

}

}
\references{
Walter, P. (2019). A Selection of Statistical Methods for Interval-Censored
Data with Applications to the German Microcensus, PhD thesis,
Freie Universitaet Berlin
}
\seealso{
\code{\link[lme4]{lmer}}, \code{\link{print.sem}},
\code{\link{plot.sem}}, \code{\link{summary.sem}}
}
