% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smdi_outcome.R
\name{smdi_outcome}
\alias{smdi_outcome}
\title{Computes association between missingness and outcome}
\usage{
smdi_outcome(
  data = NULL,
  covar = NULL,
  model = c("logistic", "linear", "cox"),
  form_lhs = NULL,
  exponentiated = FALSE,
  n_cores = 1
)
}
\arguments{
\item{data}{dataframe or tibble object with partially observed/missing variables}

\item{covar}{character covariate or covariate vector with partially observed variable/column name(s) to investigate. If NULL, the function automatically includes all columns with at least one missing observation and all remaining covariates will be used as predictors}

\item{model}{character describing which outcome model to fit to assess the association between covar missingness indicator and outcome. Currently supported are models of type logistic, linear and cox}

\item{form_lhs}{string specifying the left-hand side of the outcome formula (see details)}

\item{exponentiated}{logical, should results be exponentiated (default is FALSE)}

\item{n_cores}{integer, if >1, computations will be parallelized across amount of cores specified in n_cores (only UNIX systems)}
}
\value{
returns a tibble with univariate and adjusted estimates for each partially observed covar:
\itemize{
\item estimate_univariate: univariate association between missingness indicator of covar and outcome
\item estimate_adjusted: association between missingness indicator of covar and outcome conditional on other fully observed covariates and missing indicator variables of other partially observed covariates
}
}
\description{
This function fits outcome models with a covariate missingness indicator(s) of the covariates specified with \emph{covar}.
The estimates are computed by univariate and adjusted models on all other prognostic covariates
in the dataset. Based on the underlying missingness mechanism, the estimate for the covariate missingness indicator
may indicate a meaningful difference in the outcome between patients with vs w/o
the observed confounder conditional on other covariates that could explain that difference.

Important: don't include variables like ID variables, ZIP codes, dates, etc.
}
\details{
The function automatically fits a univariate and adjusted outcome model. The currently supported models are logistic (glm), linear (lm) and cox (survival).
For adjusted models, the function uses all available covariates found in the dataset specified with the data parameter. If covariates should not
be include in the outcome model, these covariates should be dropped beforehand (as with all other functions in the smdi package).

The left-hand side of the formula (form_lhs) needs to specify the outcome in one of the following ways:
\itemize{
\item glm (binary): character of column name with binary outcome, e.g. "MACE"
\item lm (continuous): character of column name with binary outcome, e.g. "WEIGHT_LOSS"
\item cox (time-to-event): LHS specifying time-to-event outcome, e.g. "Surv(TIME, STATUS)"
}
}
\examples{
library(smdi)

smdi_outcome(
 data = smdi_data,
 model = "cox",
 form_lhs = "Surv(eventtime, status)"
)


}
\references{
...
}
