% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.gen}
\alias{smbinning.gen}
\title{Utility to generate a new characteristic from a numeric variable}
\usage{
smbinning.gen(df, ivout, chrname = "NewChar")
}
\arguments{
\item{df}{Dataset to be updated with the new characteristic.}

\item{ivout}{An object generated after \code{smbinning} or \code{smbinning.custom}.}

\item{chrname}{Name of the new characteristic.}
}
\value{
A data frame with the binned version of the original characteristic.
}
\description{
It generates a data frame with a new predictive characteristic after applying
\code{smbinning} or \code{smbinning.custom}.
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data
pop=chileancredit # Set population
train=subset(pop,rnd<=0.7) # Training sample

# Binning application for a numeric variable
result=smbinning(df=train,y="fgood",x="dep") # Run and save result

# Generate a dataset with binned characteristic
pop=smbinning.gen(pop,result,"g1dep")

# Check new field counts
table(pop$g1dep)
}
