% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spscan.test.R
\name{spscan.test}
\alias{spscan.test}
\title{Spatial Scan Test}
\usage{
spscan.test(
  x,
  case = 2,
  nsim = 499,
  alpha = 0.1,
  maxd = NULL,
  cl = NULL,
  longlat = FALSE
)
}
\arguments{
\item{x}{A \code{\link[spatstat.geom]{ppp}} object with marks for the case
and control groups.}

\item{case}{The name of the desired "case" group in
\code{levels(x$marks)}. Alternatively, the position of
the name of the "case" group in \code{levels(x$marks)}.
Since we don't know the group names, the default is 2,
the second position of \code{levels(x$marks)}.
\code{x$marks} is assumed to be a factor.  Automatic
conversion is attempted if it is not.}

\item{nsim}{The number of simulations from which to compute the p-value.  A
non-negative integer.  Default is 499.}

\item{alpha}{The significance level to determine whether a cluster is
signficant.  Default is 0.1.}

\item{maxd}{The radius of the largest possible cluster to consider.  Default
is \code{NULL}, i.e., half the maximum intercentroid distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{longlat}{A logical value indicating whether
Euclidean distance (\code{FALSE}) or Great Circle
(WGS84 ellipsoid, \code{FALSE}) should be used. Default
is \code{FALSE}, i.e., Euclidean distance.}
}
\value{
Returns a list of length two of class 
  \code{scan}. The first element (clusters) is a list 
  containing the significant, non-overlapping clusters, 
  and has the the following components: 
  \item{coords}{The
  centroid of the significant clusters.} 
  \item{r}{The 
  radius of the window of the clusters.} 
  \item{pop}{The 
  total population in the cluser window.} 
  \item{cases}{The observed number of cases in the 
  cluster window.} 
  \item{expected}{The expected number of
  cases in the cluster window.} 
  \item{smr}{Standarized 
  mortaility ratio (observed/expected) in the cluster 
  window.} 
  \item{rr}{Relative risk in the cluster 
  window.} \item{propcases}{Proportion of cases in the 
  cluster window.} 
  \item{loglikrat}{The loglikelihood 
  ratio for the cluster window (i.e., the log of the test
  statistic).} 
  \item{pvalue}{The pvalue of the test 
  statistic associated with the cluster window.} 
  
  Various additional pieces of information are included for plotting,
  printing
}
\description{
\code{spscan.test} performs the spatial scan test of Kulldorf (1997) for
case/control point data.
}
\details{
The test is performed using the random labeling hypothesis.  The windows are
circular and extend from the observed data locations.  The clusters returned
are non-overlapping, ordered from most significant to least significant.  The
first cluster is the most likely to be a cluster.  If no significant clusters
are found, then the most likely cluster is returned (along with a warning).

Setting \code{cl} to a positive integer MAY speed up computations on
non-Windows computers.  However, parallelization does have overhead cost, and
there are cases where parallelization results in slower computations.
}
\examples{
data(grave)
# apply scan method
out = spscan.test(grave, case = "affected", nsim = 99)
# print scan object
out
print(out, extra = TRUE)
# summarize results
summary(out)
# plot results
plot(out, chars = c(1, 20), main = "most likely cluster")
# extract clusters from out 
# each element of the list gives the location index of the events in each cluster
clusters(out)
# get warning if no significant cluster
out2 = spscan.test(grave, case = 2, alpha = 0.001, nsim = 99)
}
\references{
Kulldorff M., Nagarwalla N. (1995) Spatial
  disease clusters: Detection and Inference. Statistics
  in Medicine 14, 799-810.
  
  Kulldorff, M. (1997) A spatial scan statistic.
  Communications in Statistics -- Theory and Methods 26,
  1481-1496.
  
  Waller, L.A. and Gotway, C.A. (2005). Applied Spatial
  Statistics for Public Health Data. Hoboken, NJ: Wiley.
}
\author{
Joshua French
}
