% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpowerStressMin.R
\name{rpowerStressMin}
\alias{rpowerStressMin}
\alias{rpowerstressMin}
\alias{rpostmds}
\alias{rpstressMin}
\alias{rpStressMin}
\alias{rpstressmds}
\title{Restricted Power Stress SMACOF}
\usage{
rpowerStressMin(
  delta,
  expo = 1,
  nu = 1,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

rpowerstressMin(
  delta,
  expo = 1,
  nu = 1,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

rpostmds(
  delta,
  expo = 1,
  nu = 1,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

rpstressMin(
  delta,
  expo = 1,
  nu = 1,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

rpStressMin(
  delta,
  expo = 1,
  nu = 1,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

rpstressmds(
  delta,
  expo = 1,
  nu = 1,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{expo}{power of the transformation of the fitted distances and dissimilarities; defaults to 1}

\item{nu}{the power of the transformation for weightmat; defaults to 1}

\item{type}{what type of MDS to fit. One of "ratio" or "interval". Default is "ratio".}

\item{weightmat}{a matrix of finite weights}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{acc}{numeric accuracy of the iteration. Default is 1e-6.}

\item{itmax}{maximum number of iterations. Default is 10000.}

\item{verbose}{should iteration output be printed; if > 1 then yes}

\item{principal}{If 'TRUE', principal axis transformation is applied to the final configuration}
}
\value{
a 'smacofP' object (inheriting from 'smacofB', see \code{\link[smacof]{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed, untransformed dissimilarities
\item tdelta: Observed explicitly transformed dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats), optimally scaled and normalized 
\item confdist: Transformed configuration distances
\item conf: Matrix of fitted configuration
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point 
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model 
\item weightmat: weighting matrix as supplied 
\item stress.m: Default stress (stress-1^2)
\item tweightmat: transformed weighthing matrix (here weightmat^nu)
\item parameters, pars, theta: The parameter vector of the explicit transformations
}
}
\description{
An implementation to minimize restricted power stress by majorization with ratio or interval optimal scaling. Restricted means that the same power is used for both dissimilarities and fitted distances. Uses a repeat loop.
}
\examples{
dis<-smacof::kinshipdelta
res<-rpowerStressMin(as.matrix(dis),expo=1.7,itmax=1000)
res
summary(res)
plot(res)

}
