% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sammon.R
\name{sammon}
\alias{sammon}
\title{Wrapper to \code{sammon} for S3 class}
\usage{
sammon(d, y = NULL, k = 2, ...)
}
\arguments{
\item{d}{a distance structure such as that returned by 'dist' or a full symmetric matrix.  Data are assumed to be dissimilarities or relative distances, but must be positive except for self-distance.  This can contain missing values.}

\item{y}{An initial configuration. If NULL, \code{\link[smacofx]{cmdscale}} is used to provide the classical solution. (If there are missing values in 'd', an initial configuration must be provided.)  This must not have duplicates.}

\item{k}{The dimension of the configuration}

\item{...}{Additional parameters passed to \code{sammon}, see \code{\link{sammon}}}
}
\value{
Object of class 'sammonx' inheriting from \code{\link{sammon}}. This wrapper adds an extra slot to the list with the call, adds column labels to the $points, adds slots conf=points, delta=d, dhat=normalized dissimilarities, confdist=distance between points in conf, stress.m=stress, stress=sqrt(stress.m) and assigns S3 classes 'sammonx', 'sammon' and 'cmdscalex'.
}
\description{
Wrapper to \code{sammon} for S3 class
}
\details{
Overloads MASS::sammon and adds new slots and class attributes for which there are methods.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
res<-sammon(dis)
}
